/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.unreal.t3dgenerator;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.T3dGeneratorException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.PropertyUtils;

public class ReflectionUtils {
    public ReflectionUtils() {
        throw new RuntimeException("Cannot instantiate static class");
    }

    public static <E extends Throwable> void processEachDeclaredField(Object targetObject, ProcessFieldCallback<E> callBack) throws E {
        ReflectionUtils.processEachDeclaredField(targetObject, Object.class, callBack);
    }

    public static <E extends Throwable> void processEachDeclaredField(Object targetObject, Class rootClass, ProcessFieldCallback<E> callBack) throws E {
        if (!rootClass.isAssignableFrom(targetObject.getClass())) {
            throw new IllegalArgumentException("TargetObject must be instance of rootClass");
        }
        for (Class<?> inspectedClass = targetObject.getClass(); inspectedClass != null && rootClass.isAssignableFrom(inspectedClass); inspectedClass = inspectedClass.getSuperclass()) {
            for (Field f : inspectedClass.getDeclaredFields()) {
                callBack.processField(f);
            }
        }
    }

    public static <T extends Annotation, E extends Throwable> void processEachAnnotatedDeclaredField(Object targetObject, Class<T> annotationClass, ProcessAnnotatedFieldCallback<T, E> callBack) throws E {
        ReflectionUtils.processEachAnnotatedDeclaredField(targetObject, Object.class, annotationClass, callBack);
    }

    public static <T extends Annotation, E extends Throwable> void processEachAnnotatedDeclaredField(final Object targetObject, Class rootClass, final Class<T> annotationClass, final ProcessAnnotatedFieldCallback<T, E> callBack) throws E {
        ReflectionUtils.processEachDeclaredField(targetObject, rootClass, new ProcessFieldCallback<E>(){

            @Override
            public void processField(Field f) throws Throwable {
                if (f.isAnnotationPresent(annotationClass)) {
                    Object fieldValue;
                    try {
                        fieldValue = PropertyUtils.getProperty((Object)targetObject, (String)f.getName());
                    }
                    catch (Exception ex) {
                        throw new T3dGeneratorException("Could not read property value for annotated property '" + f.getName() + "' in class" + f.getDeclaringClass().getName() + "\nThe property should have public getter.", ex);
                    }
                    callBack.processField(f, fieldValue, f.getAnnotation(annotationClass));
                }
            }
        });
    }

    public static <T extends Annotation> void processEachAnnotatedDeclaredMethod(Object targetObject, Class<T> annotationClass, ProcessAnnotatedMethodCallback<T> callBack) {
        ReflectionUtils.processEachAnnotatedDeclaredMethod(targetObject, Object.class, annotationClass, callBack);
    }

    public static <T extends Annotation> void processEachAnnotatedDeclaredMethod(Object targetObject, Class rootClass, Class<T> annotationClass, ProcessAnnotatedMethodCallback<T> callBack) {
        if (!rootClass.isAssignableFrom(targetObject.getClass())) {
            throw new IllegalArgumentException("TargetObject must be instance of rootClass");
        }
        for (Class<?> inspectedClass = targetObject.getClass(); inspectedClass != null && rootClass.isAssignableFrom(inspectedClass); inspectedClass = inspectedClass.getSuperclass()) {
            for (Method f : inspectedClass.getDeclaredMethods()) {
                if (!f.isAnnotationPresent(annotationClass)) continue;
                callBack.processMethod(f, f.getAnnotation(annotationClass));
            }
        }
    }

    public static interface ProcessFieldCallback<E extends Throwable> {
        public void processField(Field var1) throws E;
    }

    public static interface ProcessAnnotatedFieldCallback<T extends Annotation, E extends Throwable> {
        public void processField(Field var1, Object var2, T var3) throws E;
    }

    public static interface ProcessAnnotatedMethodCallback<T extends Annotation> {
        public void processMethod(Method var1, T var2);
    }
}

