/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.map;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.UnrealChild;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.UnrealComponent;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.Point3D;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.Rotation3D;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.StaticReference;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.UnrealReference;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.AbstractUnrealActor;

/**
 *
 * @author Martin Cerny
 */
public class PrefabInstance extends AbstractUnrealActor {
    private UnrealReference templatePrefab;

    @UnrealComponent
    private PrefabSpriteComponent spriteComponent = new PrefabSpriteComponent();
    
    public PrefabInstance(String prefabName, Point3D location) {
        this(prefabName,location,new Rotation3D(0, 0, 0));
    }

    public PrefabInstance(String prefabName, Point3D location, Rotation3D rotation) {
        super("PrefabInstance", "Engine.Default__PrefabInstance");
        templatePrefab = new StaticReference("Prefab", prefabName);
        setLocation(location);
        setRotation(rotation);
    }

    public UnrealReference getTemplatePrefab() {
        return templatePrefab;
    }

    public PrefabSpriteComponent getSpriteComponent() {
        return spriteComponent;
    }



}
