/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.unreal.t3dgenerator.elements;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.FieldName;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.UnrealHeaderField;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.UnrealProperty;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.DynamicReference;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.StaticReference;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.UnrealReference;

/**
 *
 * @author Martin Cerny
 */
public class AbstractUnrealBean implements IUnrealReferencableByName, IUnrealReferencable {

    @UnrealHeaderField("Class")
    private String className;
    @UnrealHeaderField
    private String name;
    @UnrealHeaderField
    @UnrealProperty
    @FieldName("ObjectArchetype")
    private UnrealReference archetype;

    public static String getDefaultArchetype(String className) {
        return "Engine.Default__" + className;
    }

    public AbstractUnrealBean() {
    }

    public AbstractUnrealBean(String className) {
        this(className,getDefaultArchetype(className), null);        
    }

    public AbstractUnrealBean(String className, UnrealReference archetype) {
        this(className, archetype, null);
    }

    public AbstractUnrealBean(String className, String archetypeName) {
        this(className, archetypeName, null);
    }

    public AbstractUnrealBean(String className, String archetypeName, String name) {
        this(className, new StaticReference(className, archetypeName), name);
    }

    public AbstractUnrealBean(String className, UnrealReference archetype, String name) {
        this.className = className;
        this.name = name;
        this.archetype = archetype;
    }

    /**
     * Gets name of the object that should be used for references. Default implementation
     * returns {@link #getName() }, but may be overriden.
     * @return
     */
    @UnrealProperty
    @FieldName("Name")
    @Override
    public String getNameForReferences() {
        return getName();
    }

    /**
     * Sets name of the object that should be used for references. Default implementation
     * calls {@link #setName(String) }, but may be overriden.
     * @return
     */
    @Override
    public void setNameForReferences(String nameForReferences) {
        setName(nameForReferences);
    }

    public UnrealReference getArchetype() {
        return archetype;
    }

    @Override
    public String getClassName() {
        return className;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public UnrealReference getReference() {
        return new DynamicReference(this);
    }
}
