/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.unreal.t3dgenerator;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.T3dGeneratorException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.PropertyUtils;

/**
 *
 * @author Martin Cerny
 */
public class ReflectionUtils {

    public ReflectionUtils() {
        throw new RuntimeException("Cannot instantiate static class");
    }

    public static interface ProcessAnnotatedMethodCallback<T extends java.lang.annotation.Annotation> {
        void processMethod(Method m, T annotation);
    }
    
    public static interface ProcessAnnotatedFieldCallback<T extends java.lang.annotation.Annotation, E extends Throwable> {
        void processField(Field f,Object fieldValue, T annotation) throws E;
    }

    public static interface ProcessFieldCallback<E extends Throwable> {
        void processField(Field f) throws E;
    }

    public static <E extends Throwable>  void processEachDeclaredField(Object targetObject, ProcessFieldCallback<E> callBack) throws E{
        processEachDeclaredField(targetObject,Object.class, callBack);
    }
    
    public static <E extends Throwable>  void processEachDeclaredField(Object targetObject, Class rootClass,ProcessFieldCallback<E> callBack) throws E{
        if(!rootClass.isAssignableFrom(targetObject.getClass())){
            throw new IllegalArgumentException("TargetObject must be instance of rootClass");
        }
        Class inspectedClass = targetObject.getClass();
        while(inspectedClass != null && rootClass.isAssignableFrom(inspectedClass)){
            for(Field f : inspectedClass.getDeclaredFields()){
                callBack.processField(f);
            }
            inspectedClass = inspectedClass.getSuperclass();
        }

    }


    public static <T extends java.lang.annotation.Annotation, E extends Throwable>  void processEachAnnotatedDeclaredField(final Object targetObject, final Class<T> annotationClass, final ProcessAnnotatedFieldCallback<T, E> callBack) throws E{
        processEachAnnotatedDeclaredField(targetObject, Object.class, annotationClass, callBack);
    }

    public static <T extends java.lang.annotation.Annotation, E extends Throwable>  void processEachAnnotatedDeclaredField(final Object targetObject, final Class rootClass, final Class<T> annotationClass, final ProcessAnnotatedFieldCallback<T, E> callBack) throws E{

        processEachDeclaredField(targetObject, rootClass, new ProcessFieldCallback<E>() {

            @Override
            public void processField(Field f) throws E {
                if(f.isAnnotationPresent(annotationClass)){
                    Object fieldValue;
                    try {
                         fieldValue = PropertyUtils.getProperty(targetObject, f.getName());
                    } catch (Exception ex) {
                        throw new T3dGeneratorException("Could not read property value for annotated property '" + f.getName() + "' in class" + f.getDeclaringClass().getName() + "\nThe property should have public getter.", ex);
                    }
                    callBack.processField(f, fieldValue, f.getAnnotation(annotationClass));
                }
            }
        });

        
    }

    
    public static <T extends java.lang.annotation.Annotation>  void processEachAnnotatedDeclaredMethod(final Object targetObject, final Class<T> annotationClass, final ProcessAnnotatedMethodCallback<T> callBack){
        processEachAnnotatedDeclaredMethod(targetObject, Object.class, annotationClass, callBack);
    }
    
    public static <T extends java.lang.annotation.Annotation>  void processEachAnnotatedDeclaredMethod(final Object targetObject, final Class rootClass, final Class<T> annotationClass, final ProcessAnnotatedMethodCallback<T> callBack){

        if(!rootClass.isAssignableFrom(targetObject.getClass())){
            throw new IllegalArgumentException("TargetObject must be instance of rootClass");
        }
        Class inspectedClass = targetObject.getClass();
        while(inspectedClass != null && rootClass.isAssignableFrom(inspectedClass)){
            for(Method f : inspectedClass.getDeclaredMethods()){
                if(f.isAnnotationPresent(annotationClass)){
                    callBack.processMethod(f,f.getAnnotation(annotationClass));
                }
            }
            inspectedClass = inspectedClass.getSuperclass();
        }
        
    }
    
}
