/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.map;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.UnrealComponent;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.UnrealProperty;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.Point3D;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.AbstractUnrealActor;

/**
 *
 * @author Martin Cerny
 */
public class Trigger extends AbstractUnrealActor{

    
    @UnrealProperty
    @UnrealComponent
    private CollisionCylinderComponent cylinderComponent;
    
    @UnrealComponent
    private SpriteComponent spriteComponent;
    
    
    public Trigger(Point3D location, float collisionHeight, float collisionRadius) {
        this(location, new CollisionCylinderComponent("Engine.Default__Trigger:CollisionCylinder", collisionHeight, collisionRadius));
    }
        
    public Trigger(Point3D location, CollisionCylinderComponent cylinderComponent) {
        super("Trigger");
        setLocation(location);
        this.cylinderComponent = cylinderComponent;
        this.spriteComponent = new SpriteComponent("Engine.Default__Trigger:Sprite", "EditorResources.S_Trigger", "Triggers");
        setCollisionComponent(cylinderComponent);        
    }

    public CollisionCylinderComponent getCylinderComponent() {
        return cylinderComponent;
    }

    public SpriteComponent getSpriteComponent() {
        return spriteComponent;
    }
    
    
    
    
}
