/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.UnrealDataType;

@UnrealDataType
public class Vector3D {
    float x;
    float y;
    float z;
    public static final Vector3D ZERO = new Vector3D(0.0f, 0.0f, 0.0f);
    public static final Vector3D X_AXIS = new Vector3D(1.0f, 0.0f, 0.0f);
    public static final Vector3D Y_AXIS = new Vector3D(0.0f, 1.0f, 0.0f);
    public static final Vector3D Z_AXIS = new Vector3D(0.0f, 0.0f, 1.0f);

    public Vector3D(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public Vector3D multiply(float a) {
        return new Vector3D(this.x * a, this.y * a, this.z * a);
    }

    public Vector3D divide(float a) {
        return new Vector3D(this.x / a, this.y / a, this.z / a);
    }

    public Vector3D add(Vector3D p) {
        return new Vector3D(this.x + p.getX(), this.y + p.getY(), this.z + p.getZ());
    }

    public Vector3D subtract(Vector3D p) {
        return new Vector3D(this.x - p.getX(), this.y - p.getY(), this.z - p.getZ());
    }

    public Vector3D negateX() {
        return new Vector3D(-this.getX(), this.getY(), this.getZ());
    }

    public Vector3D negateY() {
        return new Vector3D(this.getX(), -this.getY(), this.getZ());
    }

    public Vector3D negateXandY() {
        return new Vector3D(-this.getX(), -this.getY(), this.getZ());
    }

    public Vector3D switchXandY() {
        return new Vector3D(this.getY(), this.getX(), this.getZ());
    }

    public Vector3D negate() {
        return new Vector3D(-this.x, -this.y, -this.z);
    }

    public Vector3D crossProduct(Vector3D p) {
        return new Vector3D(this.y * p.z - this.z * p.y, this.z * p.x - this.x * p.z, this.x * p.y - this.y * p.x);
    }

    public float dotProduct(Vector3D v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector3D normalize() {
        return this.divide((float)this.length());
    }

    public static Vector3D centroid(Vector3D ... points) {
        if (points.length <= 0) {
            throw new IllegalArgumentException("At least one point must be given");
        }
        Vector3D sum = points[0];
        for (int i = 1; i < points.length; ++i) {
            sum = sum.add(points[i]);
        }
        return sum.divide(points.length);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3D other = (Vector3D)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + Float.floatToIntBits(this.x);
        hash = 31 * hash + Float.floatToIntBits(this.y);
        hash = 31 * hash + Float.floatToIntBits(this.z);
        return hash;
    }

    public String toString() {
        return "Point3D{x=" + this.x + "y=" + this.y + "z=" + this.z + '}';
    }
}

