/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.base.agent;

import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.nb.pogamut.base.agent.LogsNode;
import cz.cuni.amis.nb.pogamut.base.introspection.FolderNode;
import cz.cuni.amis.nb.util.Updater;
import cz.cuni.amis.nb.util.collections.ObservableCollectionNode;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStatePaused;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStatePausing;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateResuming;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogClient;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogEnvelope;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.collections.ObservableList;
import cz.cuni.amis.utils.flag.FlagListener;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.util.LinkedList;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public abstract class AgentNode<T extends IAgent>
extends ObservableCollectionNode<Node>
implements Updater {
    protected List<Runnable> updateSubtasks = new LinkedList<Runnable>();
    FlagListener<IAgentState> agentStateListener = new FlagListener<IAgentState>(){

        public void flagChanged(IAgentState changedValue) {
            if (changedValue instanceof IAgentStateDown) {
                AgentNode.this.logClient.stop();
            }
            AgentNode.this.fireIconChange();
        }
    };
    protected T agent = null;
    protected NetworkLogClient logClient = null;
    Image agentIcon = null;

    public AgentNode(T agent) {
        super((ObservableCollection<Node>)new ObservableList(new LinkedList()));
        this.agent = agent;
        this.setName(agent.getName());
        agent.getState().addListener(this.agentStateListener);
        agent.getLogger().addDefaultNetworkHandler();
        try {
            this.getChildrenCollection().add((Object)new LogsNode(agent.getLogger()));
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        try {
            this.getChildrenCollection().add((Object)new FolderNode.Root((IAgent)agent, this));
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        IAgentLogger agentLogger = agent.getLogger();
        String networkLogHost = agentLogger.getNetworkLoggerHost();
        Integer networkLogPort = agentLogger.getNetworkLoggerPort();
        String agentId = agent.getComponentId().getToken();
        this.logClient = new NetworkLogClient(agent.getLogger().getNetworkLoggerHost(), agent.getLogger().getNetworkLoggerPort().intValue(), agent.getComponentId().getToken());
        this.logClient.addListener(new NetworkLogClient.ILogReadListener((IAgent)agent){
            final /* synthetic */ IAgent val$agent;
            {
                this.val$agent = iAgent;
            }

            public void notify(NetworkLogClient.LogRead event) {
                NetworkLogEnvelope record = event.getRecord();
                LogCategory category = this.val$agent.getLogger().getCategory(record.getCategory());
                category.log(record.asLogRecord());
            }
        });
        this.logClient.start();
        if (this.logClient.getConnected().getFlag() == null || !((Boolean)this.logClient.getConnected().getFlag()).booleanValue()) {
            System.out.println("[WARNING] Could not connect to the network logger of agent " + agent.getComponentId().getToken() + " at " + agent.getLogger().getNetworkLoggerHost() + ":" + agent.getLogger().getNetworkLoggerPort());
        }
    }

    @Override
    public void addUpdateTask(Runnable task) {
        this.updateSubtasks.add(task);
    }

    protected boolean isEndState(IAgentState state) {
        return state.isState(new Class[]{IAgentStateStopped.class, IAgentStateFailed.class});
    }

    public T getAgent() {
        return this.agent;
    }

    public Image getIcon(int type) {
        IAgentState agentState;
        if (this.agentIcon == null) {
            this.agentIcon = this.loadAgentIcon();
        }
        if (this.isEndState(agentState = (IAgentState)this.agent.getState().getFlag())) {
            ColorSpace cs = ColorSpace.getInstance(1003);
            ColorConvertOp op = new ColorConvertOp(cs, null);
            return op.filter((BufferedImage)this.agentIcon, null);
        }
        Image badge = this.getBadgeIcon(agentState);
        return ImageUtilities.mergeImages((Image)this.agentIcon, (Image)badge, (int)4, (int)4);
    }

    private boolean isOKState(IAgentState state) {
        return state.isState(new Class[]{IAgentStateRunning.class, IAgentStateResuming.class});
    }

    protected Image getBadgeIcon(IAgentState state) {
        if (state.isState(new Class[]{IAgentStatePaused.class, IAgentStatePausing.class})) {
            return this.getBadgeIcon("Paused");
        }
        if (this.isOKState(state)) {
            return this.getBadgeIcon("Running");
        }
        return this.getBadgeIcon("Error");
    }

    private Image getBadgeIcon(String badge) {
        return ImageUtilities.loadImage((String)("cz/cuni/amis/nb/pogamut/base/icons/" + badge + "BadgeIcon.png"));
    }

    public Image getOpenedIcon(int arg0) {
        return this.getIcon(arg0);
    }

    public abstract Image loadAgentIcon();
}

