package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;

/**
 * Event raised each time some player has new emoticon set! Also emoticon resets
 * (e.g. all emoticons set to NONE) will be notified.
 * @author knight
 */
public class NewEmoticonEvent implements IWorldEvent, IWorldChangeEvent{

    UnrealId playerId;

    Emoticon emoticon;

    long simTime;

    @Override
    public long getSimTime() {
        return simTime;
    }

    /**
     * Id of the player that owns the emoticon.
     * @return
     */
    public UnrealId getPlayerId() {
        return playerId;
    }

    /**
     * Actual new emoticon.
     * @return
     */
    public Emoticon getEmoticon() {
        return emoticon;
    }

    /**
     * Default constructor.
     *
     * @param playerId
     * @param emoticon
     * @param simTime
     */
    public NewEmoticonEvent(UnrealId playerId, Emoticon emoticon, long simTime) {
        this.playerId = playerId;
        this.emoticon = emoticon;
        this.simTime = simTime;
    }

}
