package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

/**
 * Annotates map EmohawkVille.
 * @author knight
 */
public class Places extends SensomotoricModule<UT2004Bot>{

    /** for fast retrieval - list of all places */
    HashSet<Place> placesSet = new HashSet();
    /** self object */
    Self self;

    public Place getCurrentPlace() {
        if (self == null) return null;
        Location location = self.getLocation();
        for (Place place : placesSet) {
            if (place.placeReached(location))
                return place;
        }
        return null;
    }

    public Place getCurrentPlace(Location location) {
        for (Place place : placesSet) {
            if (place.placeReached(location))
                return place;
        }
        return null;
    }

    public Collection<Place> getPlaces() {
        return placesSet;
    }
    
    /**
     * Listener for Self object - stores Self object into our link.
     */
    IWorldObjectListener<Self> storeSelfListener = new IWorldObjectListener<Self>() {
        @Override
        public void notify(IWorldObjectEvent<Self> event) {
            if (self == null) {
                self = event.getObject();
                worldView.removeObjectListener(Self.class, this);
                storeSelfListener = null;
            }
        }
    };
    
    /**
     * Default constructor.
     *
     * @param agent
     */
    public Places(UT2004Bot agent) {
        super(agent);
        placesSet.addAll(Arrays.asList(Place.values()));
        worldView.addObjectListener(Self.class, storeSelfListener);
    }
}
