package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;

import java.util.HashMap;
import java.util.HashSet;

public class AnimationCharacterMapping {

    /** animation character mapping */
    static HashMap<AnimType, HashSet<CharacterType>> animCharMap = new HashMap();
    /** maps string ids to animation types */
    static HashMap<String, AnimType> stringAnimMap = new HashMap();
    /** Map speeding up searching all animations for one character */
    static HashMap<CharacterType, HashSet<AnimType>> charAnimMap = new HashMap();

    /**
     * Returns true if input animation can be played by the input character.
     *
     * @param anim
     * @param character
     * @return
     */
    public static boolean hasAnim(AnimType anim, CharacterType character) {
        if (animCharMap.containsKey(anim)) {
            if (character != null)
                return animCharMap.get(anim).contains(character);
        }
        return false;
    }

    /**
     * Returns all available animations for a character.
     * @param charType
     * @return
     */
    public static HashSet<AnimType> getAvailableAnimations(CharacterType charType) {
        if (charAnimMap.containsKey(charType))
            return charAnimMap.get(charType);

        return new HashSet();
    }

    public static AnimType getAnimTypeFromString(String animStringId) {
        if (stringAnimMap.containsKey(animStringId))
            return stringAnimMap.get(animStringId);

        return AnimType.NONE;
    }

    /**
     * Initializes character animation mapping.
     * Note: Due to Java method size limit the initialization was split into four methods.
     */
    private static void initializeCharacterAnimationMappingOne() {
        animCharMap.put(AnimType.CAMERA_ACTIVE, procCharIds(new int[]{0}));
        animCharMap.put(AnimType.AMBI_CANCAN, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_IMPATIENT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_LOOKAROUND01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_LOOKAROUND02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_LOOKBACK, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_LOOKLEFT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_LOOKRIGHT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_SCRATCH, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_SMSREAD, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY03A, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY03B, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY04, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY04A, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_ANGRY04B, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_CONFIDENT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_DEPRESSED, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_HAPPY, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_NORMAL01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_NORMAL02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_SEXY, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_SICK01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_SICK02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_WALL01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_STAND_WALL02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_THOUGHTFUL, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_THOUGHTFULTURN, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.AMBI_YAWN, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_BCROUCH, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_BRUN, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_BWALK, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_CROUCHIDLE, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.EMOHAWK_DIE01, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_DIE02, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_DIZZY, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_EEK, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_EEKFLY, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_EXPEL, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.UDN_FCROUCH, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.FIGHT_AIMDOWN01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_AIMDOWN02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_AIMFRONT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_AIMFRONT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_BEATING, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONDOWN, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONDOWNA, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONDOWNB, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONDOWNC, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONFRONT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONFRONTA, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONFRONTB, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNACTIONFRONTC, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNREADYFRONT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNWILDWEST01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_GUNWILDWEST02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_KICKDOWN, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_KICKFRONT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RIFLESHOOT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNAIMDOWN01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNAIMDOWN02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNAIMDOWN03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNAIMFRONT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNAIMFRONT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNAIMFRONT03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTDOWN01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTDOWN02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTDOWN03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTDOWNSHORT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTDOWNSHORT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTDOWNSHORT03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTFRONT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTFRONT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTFRONT03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTFRONTSHORT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTFRONTSHORT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_RUNSHOOTFRONTSHORT03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_SHOOTDOWN01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_SHOOTDOWN02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_SHOOTFRONT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_SHOOTFRONT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_SLAPS, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKAIMDOWN01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKAIMDOWN02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKAIMFRONT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKAIMFRONT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTDOWN01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTDOWN02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTDOWNSHORT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTDOWNSHORT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTFRONT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTFRONT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTFRONTSHORT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FIGHT_WALKSHOOTFRONTSHORT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.FREEZE, procCharIds(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_FRUN, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_FSPRINT, procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_FWALK, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.EMOHAWK_GROWL, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_GROWLKICK, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.UDN_HOLDGUN, procCharIds(new int[]{5}));
    }
    /**
     * Initializes character animation mapping.
     * Note: Due to Java method size limit the initialization was split into four methods.
     */
    private static void initializeCharacterAnimationMappingTwo() {
        animCharMap.put(AnimType.IDLEANIM, procCharIds(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_IDLEBREATHE, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_IDLEEARRING, procCharIds(new int[]{6}));
        animCharMap.put(AnimType.UDN_IDLEGLOVES, procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_IDLEHIP, procCharIds(new int[]{6}));
        animCharMap.put(AnimType.UDN_IDLEISCRATCH, procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_IDLEKNUCKLES, procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_IDLENECK, procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_IDLENOSE, procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_IDLESTRETCH, procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_IDLETWIST, procCharIds(new int[]{6}));
        animCharMap.put(AnimType.CAMERA_INACTIVE, procCharIds(new int[]{0}));
        animCharMap.put(AnimType.INTERACT_AUTOMAT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_CARESS, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_CARESS_BOY, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_CARESS_GIRL, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG01_END, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG01_LOOP, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG01_START, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG02_END, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG02_LOOP, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_FRONTHUG02_START, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_GOAWAY, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_HANDONSHOULDER, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_HANDOVER01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_HANDOVER02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_HANDOVER03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_HANDOVER04, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_KISSWITHHANDS01_BOY, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_KISSWITHHANDS02_BOY, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_KISSWITHHANDS_GIRL, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_KISS_BOY, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_KISS_GIRL, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_LISTENWALL, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_LISTENWALLHAND01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_LISTENWALLHAND02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_MANIPULATE01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_MANIPULATE02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PICKUP01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PICKUP02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PUSHBACK, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PUTDOWN01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PUTDOWN02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PUTFRONT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_PUTFRONT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SHAKEHANDS, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SHOULDERKNOCK, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGLEFT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGLEFT_END, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGLEFT_LOOP, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGLEFT_START, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGRIGHT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGRIGHT_END, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGRIGHT_LOOP, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_SIDEHUGRIGHT_START, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_THROW01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_THROW02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_THROWFROMPOCKET01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_THROWFROMPOCKET02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_TOUCHHORRIFIED, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.INTERACT_WHATISTHIS, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_JUMP, procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_LCROUCH, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.EMOHAWK_LIE, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_LOOKAROUND, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.UDN_LRUN, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_LWALK, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.NAVI_BIGJUMP, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_BLOWNBACK, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_CRAWL, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_IAMCHASED, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_LIEONBACK01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_LIEONBACK02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_LIEONSTOMACH01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_LIEONSTOMACH02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_OPENDOOR_ANGRY, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_OPENDOOR_CONFIDENT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_OPENDOOR_CONFIDENT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_OPENDOOR_DEPRESSED, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_OPENDOOR_HAPPY, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_OPENDOOR_NORMAL, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_PUSH, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_RUNAWAY, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_SIT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_SIT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_SITONGROUND01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_SITONGROUND02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_SLIP, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STAIRSDOWN01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STAIRSDOWN02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STAIRSUP01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STAIRSUP02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STANDUP, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFELEFT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFELEFT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFELEFT03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFELEFT04, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFERIGHT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFERIGHT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFERIGHT03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFERIGHT04, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFESHORTLEFT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_STRAFESHORTRIGHT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_TURNPLACE01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.NAVI_TURNPLACE02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_PICKUP, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.EMOHAWK_PREEN, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_BABY_BUGGYIDLE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_BABY_BUGGYLISTEN_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_BABY_BUGGYTALK_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_CELLPHONE_LISTEN_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_CELLPHONE_TALK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_CELLPHONE_TALK_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_CELLPHONE_TEXTMESSAGE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_CELLPHONE_WALK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_DOCUMENTFILE_IDLE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_DRINK_DRINKING_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_DRINK_IDLE_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_DRINK_WALK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HEADPHONES_IDLE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HEADPHONES_WALK_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HOLDBAG_IDLE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HOLDPISTOL_BREATHE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HOLDPISTOL_IDLE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HOLDPISTOL_IN_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_HOLDPISTOL_OUT_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_IDLE_DOCUMENTFILE_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_IDLE_HEADPHONES_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_IDLE_HOLDBAG_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_MODERATE_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_MODERATE_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_NEWSPAPER_ARMIDLE_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_NEWSPAPER_ARMWALK_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_NEWSPAPER_HANDIDLE_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_NEWSPAPER_IDLEARM_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_NEWSPAPER_IDLEHAND_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_PISTOL_HOLDBREATHE_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_PISTOL_HOLDIN_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_PISTOL_HOLDOUT_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_PISTOL_IDLE_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_RIDE_BICYCLE_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_RIDE_BYCICLE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_TAKE_PICTURE_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_TROLLEY_IDLE_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_TROLLEY_WALK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_UMBRELLA_IDLE_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_UMBRELLA_IDLE_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_PROPANIMATIONS_UMBRELLA_WALK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_PUSH, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_RCROUCH, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_RIFLE, procCharIds(new int[]{5}));
        animCharMap.put(AnimType.UDN_RRUN, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.RUN_DUCKING, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.RUN_NORMAL, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.RUN_NORMAL01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.RUN_NORMAL02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.RUN_SILLY, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.RUN_SPRINT_LOOP, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.RUN_SPRINT_LOOPSTART, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.RUN_SPRINT_LOOPSTOP, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_RWALK, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.EMOHAWK_SHELTER, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.UDN_SHOVE, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.EMOHAWK_SIPHON, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_SIT01, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_SIT02, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_SITONGROUND, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_BREATHE_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_COUGH_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_DUST_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_FINGERNAIL_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_LOOKAROUND_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_NERVOUS_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_NEUTRAL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_NEUTRAL_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_RELAXED_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_ROLLHEAD_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SCRATCHHEAD_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SHRUG_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SHRUG_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SITDOWNLEFT_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SITDOWNRIGHT_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SITDOWN_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_SITDOWN_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_STANDUPLEFT_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_STANDUPRIGHT_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_STANDUP_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_THOUGHTFUL_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_TOUCHFACE_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_TOUCHHAIR_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_WAITING_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_WAITING_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_CHAIR_YAWN_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_BREATHE_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_COUGH_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_DUST_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_LOOKAROUND_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_NERVOUS_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_NEUTRAL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_NEUTRAL_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_RELAXED_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_ROLLHEAD_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_SCRATCHHEAD_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_SHRUG_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_SHRUG_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_SITDOWNLEFT_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_SITDOWNRIGHT_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_STANDUPLEFT_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_STANDUPRIGHT_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_STRETCHARMS_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_THOUGHTFUL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_TOUCHFACE_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_TOUCHHAIR_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_WAITING_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SITTING_TABLE_YAWN_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_SNOWBALL, procCharIds(new int[]{5, 6}));
    }
    /**
     * Initializes character animation mapping.
     * Note: Due to Java method size limit the initialization was split into four methods.
     */
    private static void initializeCharacterAnimationMappingThree() {
        animCharMap.put(AnimType.SOCIAL_AGREE01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_AGREE02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_ANGRYAGREE, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_ANGRYEXPLAIN, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_ANGRYLISTEN, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_ANGRYTALK01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_ANGRYTALK02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_APPLAUSE01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_APPLAUSE02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_BACK_HANDSCHEST, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_BIGLAUGH, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_BRAVISSA, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_BRAVISSB, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CALMDOWN, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CALMDOWN_LEFT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CALMDOWN_RIGHT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CANTBELIEVE, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CHAMPIONS, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CHEER, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COMEHERE, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COMETOME, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COMETOME02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COMPLIMENT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COMPLIMENT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CONVERSE01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CONVERSE02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CONVERSE02A, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CONVERSE02B, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CONVERSE02C, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_CONVERSE02D, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COOING01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COOING02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COOING03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_COOING04, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_DESPAIR01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_DESPAIR02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_DISAGREE, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_ENTHUSE, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_EXPLAIN, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_FINALWORD, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_FUCKYOU, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTUREFRONT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTUREFRONT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURELEFT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURELEFT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURELEFT03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURELEFT04, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURERIGHT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURERIGHT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURERIGHT03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GESTURERIGHT04, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_GOTHIM, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HANDSFRONT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HANDSNEXTHEAD, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HANDSONHIPS, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HAPPYDANCE01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HAPPYDANCE02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HAPPYJUMP01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HAPPYJUMP02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HEADINPALMS, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HEADKNOCK, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HEYWATCHIT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_HISSYFIT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_IDIDNOTHING, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_IDONTTHINKSO, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_LISTEN, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_LOVEACCEPT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_LOVECONFESS01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_LOVECONFESS02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_LOVEPROPOSAL, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_LOVEREFUSE, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_MEMEME, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_NOWAY, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_PERSUASION, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_PLEADING01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_PLEADING02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTANGRY, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTDOWN, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTFRONT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTHYSTERIC, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTSIDEHEAD_LEFT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTSIDEHEAD_RIGHT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTSIDE_LEFT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_POINTSIDE_RIGHT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_PROTECT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_PROTECT_SHORT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SHOCKED, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SHOUTWAVE, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SHOUTWAVEBIG, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SHRUG, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SIGH, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SLAP, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SPEAKLEFT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SPEAKLEFT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SPEAKRIGHT01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_SPEAKRIGHT02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_TALKIMPORTANT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_THATSIT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_THREATEN, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_TURNLEAVE, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_WAITHERE, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_WAVEFAR, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_WAVENEAR, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_WHATEVER, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_YOUKNOW, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.SOCIAL_YOUSEE, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CHEER_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CHEER_02, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CHEER_03, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CHEER_04, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CHEER_05, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CLAPHANDS_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CLAPHANDS_02, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CROUCH_GESTIC_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CROUCH_IDLE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CROUCH_IN_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_CROUCH_OUT_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DANCING_AGGRESSIVE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DANCING_COOL_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DANCING_NEUTRAL_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DANCING_SEXY_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DANCING_SILLY_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOCUMENTS_CHECK_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOCUMENTS_IN_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOCUMENTS_NOTE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOCUMENTS_OUT_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOCUMENTS_TAKE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOOR_KNOCK_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOOR_LISTEN_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOOR_TRYINWARDS_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_DOOR_TRYOUTWARDS_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_IDLE_CIGARETTE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_INVITE_SIT_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_LAUGH_EXTREME_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_LAUGH_LOUD_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_LAUGH_LOW_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_PRESENTATION_LEFT_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_PRESENTATION_LEFT_02, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_PRESENTATION_RIGHT_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_PRESENTATION_RIGHT_02, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_LEFT120_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_LEFT180_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_LEFT60_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_LEFT90_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_RIGHT120_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_RIGHT180_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_TURN_RIGHT60_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WALL_LEANONGESTIC_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WALL_LEANONIDLE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WALL_LEANONIN_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WALL_LEANONLISTEN_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WALL_LEANONOUT_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WAVE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WAVE_02, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WORK_MID_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_SPECIALSTANDING_WORK_TABLE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.SPRINT_LOOP, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.SPRINT_LOOPSTART, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.SPRINT_LOOPSTOP, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_STANDIDLE01, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_STANDIDLE02, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EMOHAWK_STANDIDLE03, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CHEER_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CHEER_02, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CHEER_03, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CHEER_04, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CHEER_05, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CLAPHANDS_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CLAPHANDS_02, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CROUCH_GESTIC_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CROUCH_IDLE_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CROUCH_IN_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_CROUCH_OUT_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DANCING_AGRESSIVE_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DANCING_COOL_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DANCING_NEUTRAL_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DANCING_SEXY_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DANCING_SILLY_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOCUMENTS_CHECK_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOCUMENTS_IDLE_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOCUMENTS_IN_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOCUMENTS_NOTE_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOCUMENTS_OUT_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOCUMENTS_TAKE_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOOR_KNOCK_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOOR_LISTEN_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOOR_TRYINWARDS_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_DOOR_TRYOUTWARDS_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_IDLE_CIGARETTE_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_INVITE_SIT_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_LAUGH_EXTREME_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_LAUGH_LOUD_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_LAUGH_LOW_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_PRESENTATION_LEFT_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_PRESENTATION_LEFT_02, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_PRESENTATION_RIGHT_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_PRESENTATION_RIGHT_02, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_LEFT120_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_LEFT180_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_LEFT60_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_LEFT90_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_RIGHT120_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_RIGHT180_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_RIGHT60_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_TURN_RIGHT90_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_WAVE_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_WAVE_02, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_WORK_MID, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDINGSPECIAL_WORK_TABLE, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_DRUNK_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_DRUNK_02, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_ANGRY_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_ANGRY_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_BREATHE_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_BREATHE_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_BREATHE_03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_COUGH_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_COUGH_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_DRUNK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_DRUNK_02, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_DUST_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_DUST_02, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_FINGERNAIL_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_LOOKAROUND_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_LOOKAROUND_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_LOOKAROUND_03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_MOVELEG_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_MOVE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NERVOUS_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NERVOUS_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NERVOUS_03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_04, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_05, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_06, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_07, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_08, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_NEUTRAL_09, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_ROLLHEAD_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_ROLLHEAD_02, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_SCRATCHHEAD_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_SCRATCHHEAD_02, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_SHAKEARMS_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_SHAKELEG_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_STRETCHARMS_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_TOUCHFACE_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_TOUCHFACE_02, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_TOUCHHAIR_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_WAITING_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_WAITING_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_IDLE_YAWN_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_ACCEPT_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_ACCEPT_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_ACCEPT_03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_ACCEPT_04, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_ACCEPT_05, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_ANGRY_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_DENY_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_DENY_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_DENY_03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_DENY_04, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_DENY_05, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_DENY_06, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_EXCITED_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_LEFT_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_NERVOUS_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_NEUTRAL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_NEUTRAL_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_NEUTRAL_03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_RELAXED_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_RIGHT_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_SAD_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_LISTEN_SELFASSURED_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_SHRUG_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_SHRUG_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_ANGRY_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_ANGRY_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_COOL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_EXCITED_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_EXCITED_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_FEMALESTRESSED_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_LEFT_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NERVOUS_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NERVOUS_02, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NEUTRAL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NEUTRAL_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NEUTRAL_03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NEUTRAL_04, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_NEUTRAL_05, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_RELAXED_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_RELAXED_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_RIGHT_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_SAD_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_SELFASSURED_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_TALK_SELFASSURED_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_STANDING_THOUGHTFUL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.UDN_SWIM, procCharIds(new int[]{5, 6}));
        animCharMap.put(AnimType.UDN_THROW, procCharIds(new int[]{5}));
    }
    /**
     * Initializes character animation mapping.
     * Note: Due to Java method size limit the initialization was split into four methods.
     */
    private static void initializeCharacterAnimationMappingFour() {
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_ASCEND_STAIRSSTART_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_ASCEND_STAIRS_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_DESCEND_STAIRSSTART_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_DESCEND_STAIRS_01, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_RUN_NEUTRAL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_RUN_START_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_RUN_STOP_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_RUN_TOWALK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_STAIRS_ASCENDSTART_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_STAIRS_ASCEND_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_STAIRS_DESCENDSTART_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_STAIRS_DESCEND_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_TURN_LEFT120TOWALK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_TURN_LEFT180TOWALK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_TURN_LEFT60TOWALK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_TURN_RIGHT120TOWALK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_TURN_RIGHT180TOWALK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_TURN_RIGHT60TOWALK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_WALK_NEUTRAL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_WALK_START_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_WALK_STOP_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKINGRUNNINGSYSTEM_WALK_TORUN_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_EXTREMEFEMALE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_FAST_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_FAST_02, procCharIds(new int[]{1, 32, 33, 36, 7, 40, 10, 13, 14, 15, 17, 16, 19, 18, 20, 22, 25, 24, 26, 28, 30}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_INJURED_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_NEUTRAL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_NEUTRAL_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_OBESE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_OBESE_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_SLOW_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_RUN_SLOW_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_BRUISED_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_COOL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_COOL_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_DRUNK_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_EXTREMEFEMALE_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_FAST_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_FAST_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_FAST_03, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_NEUTRAL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_NEUTRAL_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_NEUTRAL_03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_OBESE_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_OBESE_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_SELFASSURED_01, procCharIds(new int[]{34, 35, 2, 3, 38, 39, 37, 8, 9, 11, 12, 21, 23, 27, 29, 31}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_SLOW_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_SLOW_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_STROLL_01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.EXT_WALKING_WALK_STROLL_02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_ANGRY01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_ANGRY02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_BACK, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_BACKWALK, procCharIds(new int[]{1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_BACK_LOOP, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_BACK_REACTIONTOPUSH, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_CARRY01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_CARRY02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_CONFIDENT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_CONFIDENTSHORT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING01START, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING02START, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING03, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING04, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING05, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING06, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING07, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_COOING08, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_DEPRESSED, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_DEPRESSEDSHORT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_DIZZY, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.WALK_DRUNK, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_ENTHUSE01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_ENTHUSE02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_HAPPY, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_HAPPYSHORT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_HEADTURNING, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_INJURED, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_LOOP, procCharIds(new int[]{1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_LOOPSTART, procCharIds(new int[]{1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_LOOPSTOP, procCharIds(new int[]{1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_MONSTER01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_MONSTER02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_NORMAL, procCharIds(new int[]{4}));
        animCharMap.put(AnimType.WALK_NORMAL01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_NORMAL02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SEXY, procCharIds(new int[]{1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SEXYSHORT, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKLEFT_FEMALE01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKLEFT_FEMALE02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKLEFT_MALE01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKLEFT_MALE02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKRIGHT_FEMALE01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKRIGHT_FEMALE02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKRIGHT_MALE01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_SPEAKRIGHT_MALE02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_TIRED, procCharIds(new int[]{1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_ZOMBIE01, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));
        animCharMap.put(AnimType.WALK_ZOMBIE02, procCharIds(new int[]{1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 34, 35, 32, 33, 38, 39, 36, 37, 40}));

    }

    /**
     * Builds arraylist containing characters that can play the animation.
     * @param charactersArray
     * @return
     */
    private static HashSet<CharacterType> procCharIds(int[] charactersArray) {
        HashSet<CharacterType> characterSet = new HashSet();

        for (int i = 0; i < charactersArray.length; i++) {
            for (CharacterType charType : CharacterType.values()) {
                if (charType.getCharacterID() == charactersArray[i]) {
                    characterSet.add(charType);
                }
            }
        }

        return characterSet;
    }

    /**
     * Default static constructor initializes the mapping.
     */
	static {
        /** Note: Due to Java method size limit the initialization was split into four methods.  */
        initializeCharacterAnimationMappingOne();
        initializeCharacterAnimationMappingTwo();
        initializeCharacterAnimationMappingThree();
        initializeCharacterAnimationMappingFour();

        //creates hashmap for fast string to animation type mapping
        for (AnimType at : animCharMap.keySet()) {
            stringAnimMap.put(at.unrealID, at);
            // adding this animation for all characters it can be played on
            for (CharacterType charType : animCharMap.get(at)) {
                if (!charAnimMap.containsKey(charType))
                    charAnimMap.put(charType, new HashSet());
                charAnimMap.get(charType).add(at);
            }
        }
    }
}
