package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.action;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceDistanceTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IPawn;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.PawnReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.StovePlateReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.ITurner;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.FryingPanReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.IFryingPan;

/** Flip ingredients on frying pan
 */
public class FlipIngredientsActionReplica extends AbstractActionReplica {
	
	public static final float ERROR_PERFORMER_NOT_PAWN = 10f;
	public static final float ERROR_FRYING_PAN_INVALID = 11f;
	public static final float ERROR_OUT_OF_RANGE = 12f;
	public static final float ERROR_TURNER_REQUIRED = 13f;
	
	public static final float DEFAULT_RANGE = 200.0f;
	
	public static final String RANGE_ATTR = "range";
		
	@Override
	public String getActionName() {
		return "Flip ingredients on frying pan";
	}
	
	/** Get range
	 */
	public float getRange() {
		return attributes.floats().get( RANGE_ATTR );
	}
		
	/** Tell if the collector can drop an item at the location
	 */
	public boolean canReach( IPawn pawn, IFryingPan fryingPan, float rangeMultiplier ) {
		if ( fryingPan.getOwnerPossessor() instanceof StovePlateReplica ) {
			return ( 
				EssenceDistanceTools.computeDistanceOfEssences( pawn, fryingPan.getOwnerPossessor() ) 
				<=
				getRange()*rangeMultiplier
			);
		}
	
		return ( 
			EssenceDistanceTools.computeDistanceOfEssences( pawn, fryingPan ) 
			<=
			getRange()*rangeMultiplier
		);
	}
	
	/** Find scoop in a list
	 */
	public ITurner findTurner( Collection<? extends IItem> list ) {
		for ( IItem item : list ) {
			if ( item instanceof ITurner ) {
				return (ITurner) item;
			}
		}
		return null;
	}
	
	/** Request to drop at current collector location
	 * 
	 * Client-side only.
	 * 
	 * @param performer action performer
	 * @param fryingPan the frying pan
	 * @param resultHandler result handler
	 */
	public void request( PawnReplica performer, FryingPanReplica fryingPan, IActionResultHandler resultHandler ) {
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, fryingPan );
		performer.requestAction( 
			this, 
			resultHandler, 
			arguments 
		);
	}
}