package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable;



/** Cucumber slices
 */
public class CucumberSliceReplica  extends AbstractVegetableSliceReplica implements ICucumberSlice {
	
	public static final float BOILEDNESS_PER_MAGNITUDE_PER_SECOND = 0.025f;
	public static final float CHARREDNESS_PER_MAGNITUDE_PER_SECOND = 0.125f;
	public static final float CHARREDNESS_RESISTANCE = 0.050f;
	public static final float CHARREDNESS_RESISTANCE_STIRRING_BONUS = 0.075f;
	public static final float MAX_BUFFERED_CHARREDNESS = 1.00f;
	public static final float BROTH_STRENGTH_POTENTIAL = 0.04f;
			
	/** See ErbIItem
	 */
	public String getDisplayName() {
		return "Cucumber slice";
	}
	
	/** See EvAbstractVegetable
	 */
	protected void initializeParameters() {
		ingredientComponent.initializeBoilingBehavior(
			CucumberReplica.COOKING_BASE_TEMPERATURE,
			CucumberReplica.COOKING_STANDARD_TEMPERATURE,
			BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			CucumberReplica.COOKING_BASE_TEMPERATURE,
			CucumberReplica.COOKING_STANDARD_TEMPERATURE,
			CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			CHARREDNESS_RESISTANCE,
			CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = BROTH_STRENGTH_POTENTIAL;
		volumePerSlice = CucumberReplica.VOLUME_PER_WHOLE/CucumberReplica.SLICES_PER_WHOLE;
	}
}