package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.process;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.ds.FoggyRefMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.process.AbstractProcessMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.cookware.CookingPotMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.process.IStirProcess;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.process.StirProcessReplica;

public class StirProcessMemorization
	extends AbstractProcessMemorization<StirProcessReplica>
	implements IStirProcess {
	
	protected FoggyRefMemorization<CookingPotMemorization> cookingPot;
	
	public StirProcessMemorization( 
		final StirProcessReplica object,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super(object, observationMemory);
		deferredConstructorChainer.addDeferredConstructor(
			new IDeferredConstructor() {
				@Override
				public void construct() {
					if ( object.isCookingPotHidden() ) {
						cookingPot = new FoggyRefMemorization<CookingPotMemorization>( true, null );
					} else {
						CookingPotMemorization tmp = (CookingPotMemorization) observationMemory.getMemorization( object.getCookingPot() );
						cookingPot = new FoggyRefMemorization<CookingPotMemorization>( 
							false,
							tmp
						);
					}
				}
			}
		);
	}
	
	@Override
	public CookingPotMemorization getCookingPot() {
		return cookingPot.get();
	}
	
	@Override
	public boolean isCookingPotHidden() {
		return cookingPot.isHidden();
	}
}