/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributedReplication;

public class IngredientComponent {
    public static final float MAX_MAGNITUDE = 4.0f;
    protected static final String CHARREDNESS_ATTR = "charredness";
    protected static final String BOILEDNESS_ATTR = "boiledness";
    protected static final String TOP_FRIEDNESS_ATTR = "topFriedness";
    protected static final String BOTTOM_FRIEDNESS_ATTR = "bottomFriedness";
    protected static final String IS_UPSIDE_DOWN_ATTR = "isUpsideDown";
    protected float boilingBaseTemperature;
    protected float boilingStandardTemperature;
    protected float boilednessPerMagnitudePerSecond;
    protected float charringBaseTemperature;
    protected float charringStandardTemperature;
    protected float charrednessPerMagnitudePerSecond;
    protected float charrednessResistance;
    protected float charrednessResistanceStirringBonus;
    protected float maxBufferedCharredness;
    protected float fryingBaseTemperature;
    protected float fryingStandardTemperature;
    protected float friednessPerMagnitudePerSecond;
    protected IAttributedReplication attributeProvider;

    public IngredientComponent(IAttributedReplication initAttributeProvider) {
        this.attributeProvider = initAttributeProvider;
        this.boilednessPerMagnitudePerSecond = 0.0f;
        this.charrednessPerMagnitudePerSecond = 0.0f;
        this.friednessPerMagnitudePerSecond = 0.0f;
    }

    public void initializeBoilingBehavior(float initBoilingBaseTemperature, float initBoilingStandardTemperature, float initBoilednessPerMagnitudePerSecond) {
        this.boilingBaseTemperature = initBoilingBaseTemperature;
        this.boilingStandardTemperature = initBoilingStandardTemperature;
        this.boilednessPerMagnitudePerSecond = initBoilednessPerMagnitudePerSecond;
    }

    public void initializeCharringBehavior(float initCharringBaseTemperature, float initCharringStandardTemperature, float initCharrednessPerMagnitudePerSecond, float initCharrednessResistance, float initCharrednessResistanceStirringBonus, float initMaxBufferedCharredness) {
        this.charringBaseTemperature = initCharringBaseTemperature;
        this.charringStandardTemperature = initCharringStandardTemperature;
        this.charrednessPerMagnitudePerSecond = initCharrednessPerMagnitudePerSecond;
        this.charrednessResistance = initCharrednessResistance;
        this.charrednessResistanceStirringBonus = initCharrednessResistanceStirringBonus;
        this.maxBufferedCharredness = initMaxBufferedCharredness;
    }

    public void initializeFryingBehavior(float initFryingBaseTemperature, float initFryingStandardTemperature, float initFriednessPerMagnitudePerSecond) {
        this.fryingBaseTemperature = initFryingBaseTemperature;
        this.fryingStandardTemperature = initFryingStandardTemperature;
        this.friednessPerMagnitudePerSecond = initFriednessPerMagnitudePerSecond;
    }

    public float getCharredness() {
        return ((Float)this.attributeProvider.getAttributes().floats().get(CHARREDNESS_ATTR)).floatValue();
    }

    public float getBoiledness() {
        return ((Float)this.attributeProvider.getAttributes().floats().get(BOILEDNESS_ATTR)).floatValue();
    }

    public float getBottomFriedness() {
        return ((Float)this.attributeProvider.getAttributes().floats().get(BOTTOM_FRIEDNESS_ATTR)).floatValue();
    }

    public float getTopFriedness() {
        return ((Float)this.attributeProvider.getAttributes().floats().get(TOP_FRIEDNESS_ATTR)).floatValue();
    }

    public boolean getIsUpsideDown() {
        return (Boolean)this.attributeProvider.getAttributes().bools().get(IS_UPSIDE_DOWN_ATTR);
    }

    public float computeMagnitude(float temperature, float baseTemperature, float standardTemperature) {
        if (temperature <= baseTemperature) {
            return 0.0f;
        }
        float squareRoot = (temperature - baseTemperature) / (standardTemperature - baseTemperature);
        return Math.min(4.0f, squareRoot * squareRoot);
    }
}

