package cz.cuni.amis.pogamut.emohawkVille.bot.impl;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IObservationMemory;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamManager;
import cz.cuni.amis.pogamut.emohawkRpgBase.bot.impl.EmohawkRpgBaseBotController;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.essence.EssenceMap;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.essence.IEssenceMap;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;

public class EmohawkVilleBotController<BOT extends UT2004Bot<?,?,?> > extends EmohawkRpgBaseBotController<BOT> {
	
	@Override
	public IEssenceMap getEssenceMap() {
		return (IEssenceMap) essenceMap;
	}
	
	@Override
	public Game getGame() {
		return (Game) game;
	}
	
	/**
	 * Initializes memory/command modules of the bot.
	 * 
	 * @param bot
	 */
	protected void initializeModules(BOT bot) {
		super.initializeModules(bot);
		objectReplicationClient.registerModule( EssenceMap.class, (EssenceMap) essenceMap );
	}
	
	@Override
	protected Game makeGame() {
		return new Game(bot);
	};
	
	@Override
	protected IEssenceMap makeEssenceMap() {
		return new EssenceMap( world );
	}
	
	@Override
	protected ObjectReplicationClient makeObjectReplicationClient( IUT2004Bot bot, StreamManager streamManager ) {
		return new ObjectReplicationClient( bot, streamManager );
	}
	
	@Override
	protected IObservationMemory makeObservationMemory() {
		return new ObservationMemory( act, world, essenceMap, info );
	}
}
