package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.meat;

/** Beef bits
 * 
 * Cooking behavior is same as Beef's.
 */
public class BeefBitReplication extends AbstractMeatBitReplication implements IBeefBit {
		
	@Override
	public String getDisplayName() {
		return "Beef slice";
	}
	
	@Override
	protected void initializeParameters() {
		ingredientComponent.initializeBoilingBehavior(
			BeefReplication.BOILING_BASE_TEMPERATURE,
			BeefReplication.BOILING_STANDARD_TEMPERATURE,
			BeefReplication.BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeFryingBehavior(
			BeefReplication.FRYING_BASE_TEMPERATURE,
			BeefReplication.FRYING_STANDARD_TEMPERATURE,
			BeefReplication.FRIEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			BeefReplication.CHARRING_BASE_TEMPERATURE,
			BeefReplication.CHARRING_STANDARD_TEMPERATURE,
			BeefReplication.CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			BeefReplication.CHARREDNESS_RESISTANCE,
			BeefReplication.CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			BeefReplication.MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = BeefReplication.BROTH_STRENGTH_POTENTIAL;
		volumePerSlice = BeefReplication.VOLUME_PER_WHOLE/BeefReplication.SLICES_PER_WHOLE;
	}
}