package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient;

import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.AbstractSubstanceItem;

/** Broth
 */
public class BrothReplication extends AbstractSubstanceItem implements IBroth, IIngredientReplication {
	
	public static final float COOKING_BASE_TEMPERATURE = 80.0f;
	public static final float COOKING_STANDARD_TEMPERATURE = 100.0f;
	
	protected static final String STRENGTH_ATTR = "strength";

	@Override
	public float getStrength() {
		return attributes.floats().get( STRENGTH_ATTR );
	}
	
	@Override
	public float getVolume() {
		return getAmount();
	}
	
	/* Cooking tick as implemented in unreal script source:

	function cookingTick( float temperature, float heatConductivity, bool isStirred, float deltaTime )
	{
		local float magnitude;
		local EhIReadOnlyIterator_EvIIngredient ingredientIterator;
		local EvIBrothableIngredient brothable;
		magnitude = (temperature-COOKING_BASE_TEMPERATURE) / ( COOKING_STANDARD_TEMPERATURE - COOKING_BASE_TEMPERATURE );
		magnitude /= FMax( 1.0, 2 * getStrength() );
	
		`massert( `ifacecast( EvICookware, getOwnerWarehouse() ) != none, "Can be called only while in cookware." );
		ingredientIterator = `ifacecast( EvICookware, getOwnerWarehouse() ).readIngredients().makeReadOnlyIterator();
		while ( ingredientIterator.hasNext() )
		{
			brothable = `ifacecast( EvIBrothableIngredient, ingredientIterator.next() );
			if ( brothable != none )
			{
				setStrength( getStrength() + FMax( 0.0, brothable.getBrothStrengthPotential() * magnitude * deltaTime / getAmount() ) );
			}
		}
	}
	
	*/
	
	@Override
	public String getDisplayName() {
		return "Broth";
	}
	
	@Override
	public String getAmountUnitName() {
		return "L";
	}
}