package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.AbstractCountableItem;


/** Abstract solid ingredient slice
 */
public abstract class AbstractSolidIngredientSliceReplication extends AbstractCountableItem implements IBrothableIngredientReplication, ICharrableIngredientReplication, IBoilableIngredientReplication {
	
	protected IngredientComponent ingredientComponent;
	protected float brothStrengthPotential;
	protected float volumePerSlice;
	
	@Override
	public float getBrothStrengthPotential() {
		return brothStrengthPotential*getVolume();
	}
	
	@Override
	public float getVolume() {
		return volumePerSlice*getCount();
	}
	
	@Override
	public float getCharredness() {
		return ingredientComponent.getCharredness();
	}
	
	@Override
	public float getBoiledness() {
		return ingredientComponent.getBoiledness();
	}
	
	@Override
	public void initializeImage( ObjectReplicationClient initObjectReplicationClient, ReplicationId initReplicationId ) {
		super.initializeImage( initObjectReplicationClient, initReplicationId );
		ingredientComponent = new IngredientComponent( this );
		initializeParameters();
	}
	
	/** Initilialize parameters
	 * 
	 * ingredientComponent ingredient behavior
	 * brothStrengthPotential broth strentgh boiled per vegetable volume*magnitude*time/broth volume
	 * volumePerSlice volume of one vegetable slice
	 */
	abstract protected void initializeParameters();
}