package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.essence.AbstractEssenceReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainerReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.WarehouseComponent;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookware;

/** Stove plate essence
 * 
 * Container holding up to one cooking pot or one frying pan.
 */
public class StovePlateReplication extends AbstractEssenceReplication implements IStovePlate, IContainerReplication {

	public static final float HEAT_RADIATION_FACTOR_PER_TICK = 0.1f; // how big part of excess heat is radiated per tick
	public static final float HEAT_CAPACITY = 4500.0f; // heat capacity in joules per kelvin
	public static final float THERMAL_TICK_PERIOD = 1.0f; // seconds
	
	protected static final String STOVE_ATTR = "stove";
	protected static final String TEMPERATURE_ATTR = "temperature";
	
	protected WarehouseComponent warehouseComponent;
	
	@Override
	public float getTemperature() {
		return attributes.floats().get( TEMPERATURE_ATTR );
	}
	
	@Override
	public boolean canStore( IItem item ) {
		return item instanceof ICookware && readInventory().isEmpty();
	}
	
	@Override
	public boolean canRelease( IItem item ) {
		return true;
	}
	
	@Override
	public Collection<? extends IItemReplication> readInventory() {
		return warehouseComponent.readInventory();
	}
	
	@Override
	public void initializeImage( ObjectReplicationClient initObjectReplicationClient, ReplicationId initReplicationId) {
		super.initializeImage( initObjectReplicationClient, initReplicationId );
		warehouseComponent =  new WarehouseComponent( this, this );
	}
		
	@Override
	public StoveReplication getStove() {
		if ( attributes.refs().isHidden( STOVE_ATTR ) ) {
			return null;
		}
		return (StoveReplication) attributes.refs().get( STOVE_ATTR );
	}
}