package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.process;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.process.AbstractProcessMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.DishwarePlateMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.process.EatProcessReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.process.IEatProcess;

/** Eat process memorization
 * 
 * @author Paletz
 */
public class EatProcessMemorization
	extends AbstractProcessMemorization<EatProcessReplication>
	implements IEatProcess {
	
	protected DishwarePlateMemorization plate;
	
	public EatProcessMemorization(
		final EatProcessReplication object,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory );
		
		deferredConstructorChainer.addDeferredConstructor(
			new IDeferredConstructor() {
				@Override
				public void construct() {
					DishwarePlateMemorization tmp = (DishwarePlateMemorization) observationMemory.getMemorization( object.getPlate() );
					plate = tmp;
				}
			}
		);
	}

	@Override
	public DishwarePlateMemorization getPlate() {
		return plate;
	}
}
