package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.cookware;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.ds.FoggyRefMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.PawnMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.CookingPotReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookingPot;

public class CookingPotMemorization
	extends AbstractCookwareMemorization<CookingPotReplication> 
	implements ICookingPot {
	
	protected FoggyRefMemorization<PawnMemorization<?>> stirrer;
	
	public CookingPotMemorization( 
		final CookingPotReplication object,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory, CookingPotReplication.STATS, deferredConstructorChainer );
		
		deferredConstructorChainer.addDeferredConstructor(
			new IDeferredConstructor() {
				@Override
				public void construct() {
					if ( object.isStirrerHidden() ) {
						stirrer = new FoggyRefMemorization<PawnMemorization<?>>( true, null );
					} else {
						PawnMemorization<?> tmp = (PawnMemorization<?>) observationMemory.getMemorization( object.getStirrer() );
						stirrer = new FoggyRefMemorization<PawnMemorization<?>>( false, tmp );
					}
				}
			}
		);
	}

	@Override
	public boolean isStirrerHidden() {
		return stirrer.isHidden();
	}
	
	@Override
	public PawnMemorization<?> getStirrer() {
		return stirrer.get();
	}
}