package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware;

public class CookwareStats {

	protected final float heatAbsorbtionPerTick;
	protected final float heatRadiationPerTick; 
	protected final float heatCapacity;
	protected final float foodCapacity; 
	
	/** Constructor
	 * 
	 * @param heatAbsorbtionPerTick how big part of excess stove plate heat is absorbed per tick
	 * @param heatRadiationPerTick how big part of excess temperature is radiated per tick
	 * @param heatCapacity heat capacity in joules per kelvin
	 * @param foodCapacity food capacity in litres
	 */
	public CookwareStats(
		float heatAbsorbtionPerTick,
		float heatRadiationPerTick,
		float heatCapacity, 
		float foodCapacity
	) {
		super();
		this.heatAbsorbtionPerTick = heatAbsorbtionPerTick;
		this.heatRadiationPerTick = heatRadiationPerTick;
		this.heatCapacity = heatCapacity;
		this.foodCapacity = foodCapacity;
	}

	/** Get the heat absorbtion per tick
	 */
	public float getHeatAbsorbtionPerTick() {
		return heatAbsorbtionPerTick;
	}

	/** Get the heat radiation per tick
	 */
	public float getHeatRadiationPerTick() {
		return heatRadiationPerTick;
	}

	/** Get the heat capacity
	 */
	public float getHeatCapacity() {
		return heatCapacity;
	}

	/** Get the food capacity
	 */
	public float getFoodCapacity() {
		return foodCapacity;
	}	
}
