package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.AbstractContainerItemReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.FoodTools;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredientReplication;

/** Abstract cookware
 * 
 * Can hold cooking ingredients.
 * 
 * Subclasses must override getDisplayName(), makeActor() and initializeParameters().
 */
public abstract class AbstractCookwareReplication extends AbstractContainerItemReplication implements ICookwareReplication {
	
	public static final float THERMAL_TICK_PERIOD = 1.0f;
	public static final float WATER_BONUS_CONDUCTIVITY_FACTOR = 4.0f; // how much water improves conductivity
	public static final float EFFECTIVE_WATER_VOLUME_THRESHOLD = 0.1f; // water volume in liters below which conductivity bonus deteriorates linearly
	public static final float OIL_BONUS_CONDUCTIVITY_FACTOR = 1.0f; // how much oil improves conductivity
	public static final float EFFECTIVE_OIL_VOLUME_THRESHOLD = 0.01f; // oil volume in liters below which conductivity bonus deteriorates linearly
	public static final float CONDUCTIVITY_DENOMINATOR_PER_BROTH_STRENGTH = 0.001f; // how much broth strength decreases conductivity bonus
	
	protected CookwareStats stats;
	
	protected static final String TEMPERATURE_ATTR = "temperature";
	
	public AbstractCookwareReplication() {
		initializeParameters();
	}
	
	/** Get the temperature
	 * 
	 * @return temperature in degrees of celsius.
	 */
	public float getTemperature() {
		return attributes.floats().get( TEMPERATURE_ATTR );
	}
	
	@Override
	public Collection<? extends IIngredientReplication> readIngredients() {
		return FoodTools.readIngredients( readInventory() );
	}
	
	@Override
	public boolean canStore( IItem item ) {
		return FoodTools.canStoreFood( readIngredients(), item, stats.getFoodCapacity() );
	}
	
	@Override
	public boolean canRelease( IItem item ) {
		return false;
	}
	
	@Override
	public void initializeImage( ObjectReplicationClient initObjectReplicationClient, ReplicationId initReplicationId )	{
		super.initializeImage( initObjectReplicationClient, initReplicationId );
		initializeParameters();
	}
	
	/** Initilialize parameters
	 * 
	 * Should initialize stats.
	 */
	abstract protected void initializeParameters();
}