package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable;


/** Potato slices
 */
public class PotatoSliceReplication extends AbstractVegetableSliceReplication implements IPotatoSlice {
	
	public static final float BOILEDNESS_PER_MAGNITUDE_PER_SECOND = 0.0030f; 
	
	@Override
	public String getDisplayName() {
		return "Potato slice";
	}
	
	@Override
	protected void initializeParameters() {
		ingredientComponent.initializeBoilingBehavior(
			PotatoReplication.COOKING_BASE_TEMPERATURE,
			PotatoReplication.COOKING_STANDARD_TEMPERATURE,
			BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			PotatoReplication.COOKING_BASE_TEMPERATURE,
			PotatoReplication.COOKING_STANDARD_TEMPERATURE,
			PotatoReplication.CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			PotatoReplication.CHARREDNESS_RESISTANCE,
			PotatoReplication.CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			PotatoReplication.MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = PotatoReplication.BROTH_STRENGTH_POTENTIAL;
		volumePerSlice = PotatoReplication.VOLUME_PER_WHOLE/PotatoReplication.SLICES_PER_WHOLE;
	}
}