package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.AbstractSubstanceItem;

/** Spaghetti
 */
public class SpaghettiReplication extends AbstractSubstanceItem implements ISpaghetti, ICharrableIngredientReplication, IBoilableIngredientReplication {
	 
	public static final float COOKING_BASE_TEMPERATURE = 70.0f;
	public static final float COOKING_STANDARD_TEMPERATURE = 100.0f;
	public static final float BOILEDNESS_PER_MAGNITUDE_PER_SECOND = 0.0075f; 
	public static final float CHARREDNESS_PER_MAGNITUDE_PER_SECOND = 0.125f; 
	public static final float CHARREDNESS_RESISTANCE = 0.025f; 
	public static final float CHARREDNESS_RESISTANCE_STIRRING_BONUS = 0.05f; 
	public static final float MAX_BUFFERED_CHARREDNESS = 0.100f; 
	public static final float VOLUME_PER_GRAM = 0.001f; 
	
	protected IngredientComponent ingredientComponent;
	
	@Override
	public String getDisplayName() {
		return "Spaghetti";
	}
	
	@Override
	public String getAmountUnitName() {
		return "g";
	}
	
	@Override
	public float getVolume() {
		return getAmount()*VOLUME_PER_GRAM;
	}
	
	@Override
	public float getCharredness() {
		return ingredientComponent.getCharredness();
	}
	
	@Override
	public float getBoiledness() {
		return ingredientComponent.getBoiledness();
	}
	
	@Override
	public void initializeImage( ObjectReplicationClient initObjectReplicationClient, ReplicationId initReplicationId ) {
		super.initializeImage( initObjectReplicationClient, initReplicationId );
		ingredientComponent = new IngredientComponent( this );
		initializeParameters();
	}
	
	protected void initializeParameters() 
	{
		ingredientComponent.initializeBoilingBehavior(
			COOKING_BASE_TEMPERATURE,
			COOKING_STANDARD_TEMPERATURE,
			BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			COOKING_BASE_TEMPERATURE,
			COOKING_STANDARD_TEMPERATURE,
			CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			CHARREDNESS_RESISTANCE,
			CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			MAX_BUFFERED_CHARREDNESS
		);
	}
}