package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image;

import java.util.Collection;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;

import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.WaterReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredient;

/** Food tools
 */ 
public class FoodTools {
	
	/** See EvICookware
	 * 
	 * @param inventory inventory containing the ingredients and only the ingredients
	 */
	public static <IngredientType extends IIngredient, ItemType extends IItem> 
		Collection<? extends IngredientType> readIngredients( Collection<? extends ItemType> inventory ) {
		return Collections2.transform( 
			inventory,
			new Function<ItemType,IngredientType>() {
				@Override
				public IngredientType apply( ItemType arg ) {
					assert( arg instanceof IIngredient );
					@SuppressWarnings("unchecked")
					IngredientType retval = (IngredientType) arg;
					return retval;
				}
			}
		);
	}
	
	/** See ErbIContainer
	 * 
	 * @param ingredients currently stored ingredients
	 * @param foodCapacity food capacity in liters
	 */
	public static boolean canStoreFood( Collection<? extends IIngredient> ingredients, IItem item, float foodCapacity ) {
		
		if ( !( item instanceof IIngredient ) ) {
			return false;
		}
		
		IIngredient ingredient = (IIngredient) item;
		
		if ( item instanceof WaterReplication ) {
			WaterReplication water = (WaterReplication) item; 
			return foodCapacity-computeFoodVolume( ingredients ) > water.getAmount();
		}
		
		return foodCapacity-computeFoodVolume( ingredients ) > ingredient.getVolume();
	}
		
	/** Get volume
	 * 
	 * @return volume in litres
	 */
	public static float computeFoodVolume( Collection<? extends IIngredient> ingredients ) {
		
		float retval = 0.0f;
		
		for ( IIngredient ingredient : ingredients ) {
			retval += ingredient.getVolume();
		}
		
		return retval;
	}
}