/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.stream;

import cz.cuni.amis.pogamut.emohawk.communication.stream.IEncodedObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IEncodedObjectOutputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectOutputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IOutputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;

public class StreamTools {
    public static void pipeStream(IInputStream inputStream, IOutputStream outputStream) {
        while (inputStream.tellNext() != PayloadType.PAYLOAD_TYPE_EOF) {
            StreamTools.pipePrimitive(inputStream, outputStream);
        }
    }

    public static void pipeEncodedStream(IEncodedObjectInputStream inputStream, IEncodedObjectOutputStream outputStream) {
        while (inputStream.tellNext() != PayloadType.PAYLOAD_TYPE_EOF) {
            StreamTools.pipeEncodedPrimitive(inputStream, outputStream);
        }
    }

    public static void pipeObjectStream(IObjectInputStream inputStream, IObjectOutputStream outputStream) {
        while (inputStream.tellNext() != PayloadType.PAYLOAD_TYPE_EOF) {
            StreamTools.pipeObjectPrimitive(inputStream, outputStream);
        }
    }

    public static void pipePrimitive(IInputStream inputStream, IOutputStream outputStream) {
        switch (inputStream.tellNext()) {
            case PAYLOAD_TYPE_BOOL: {
                outputStream.writeBool(inputStream.readBool());
                break;
            }
            case PAYLOAD_TYPE_INT: {
                outputStream.writeInt(inputStream.readInt());
                break;
            }
            case PAYLOAD_TYPE_FLOAT: {
                outputStream.writeFloat(inputStream.readFloat());
                break;
            }
            case PAYLOAD_TYPE_STRING: {
                outputStream.writeString(inputStream.readString());
                break;
            }
            default: {
                throw new RuntimeException("Unexpected payload.");
            }
        }
    }

    public static void pipeEncodedPrimitive(IEncodedObjectInputStream inputStream, IEncodedObjectOutputStream outputStream) {
        if (inputStream.tellNext() == PayloadType.PAYLOAD_TYPE_OBJECT_REF) {
            outputStream.writeObjectRef(inputStream.readObjectRef());
        } else {
            StreamTools.pipePrimitive(inputStream, outputStream);
        }
    }

    public static void pipeObjectPrimitive(IObjectInputStream inputStream, IObjectOutputStream outputStream) {
        if (inputStream.tellNext() == PayloadType.PAYLOAD_TYPE_OBJECT_REF) {
            outputStream.writeObjectRef(inputStream.readObjectRef());
        } else {
            StreamTools.pipePrimitive(inputStream, outputStream);
        }
    }
}

