/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.bot.impl;

import cz.cuni.amis.pogamut.base.agent.IGhostAgent;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.EhAgentInfo;
import cz.cuni.amis.pogamut.emohawk.agent.action.Activeness;
import cz.cuni.amis.pogamut.emohawk.agent.game.EhGame;
import cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.emoticon.Emoticons;
import cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.navigation.EmohawkNavigation;
import cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.navigation.Steering;
import cz.cuni.amis.pogamut.emohawk.bot.impl.EmohawkBotBrain;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.IHistoricWorldView;
import cz.cuni.amis.pogamut.unreal.agent.navigation.IUnrealPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AgentConfig;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavigationGraphBuilder;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.UT2004AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004AStarPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.KefikRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.command.Communication;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotLogicController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PasswordReply;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.Random;
import java.util.logging.Logger;

public abstract class EmohawkBotController<BOT extends UT2004Bot<?, ?, ?>>
extends UT2004BotLogicController<BOT> {
    protected EmohawkBotBrain brain;
    protected Random random = new Random(System.currentTimeMillis());
    @Deprecated
    protected Game ut2004game;
    protected EhGame game;
    @Deprecated
    protected UT2004AgentInfo ut2004AgentInfo;
    protected EhAgentInfo agentInfo;
    @Deprecated
    protected AgentConfig config;
    protected Raycasting raycasting;
    protected AdvancedLocomotion movement;
    protected Communication comm;
    protected UT2004PathExecutor<ILocated> pathExecutor = null;
    protected IPathPlanner<ILocated> pathPlanner = null;
    protected NavigationGraphBuilder navGraphBuilder;
    protected FloydWarshallMap fwMap;
    protected Steering steering;
    protected EmohawkNavigation navigation;
    protected AnnotationListenerRegistrator annotationListenerRegistrator;
    protected IAct act;
    @Deprecated
    protected Emoticons emoticons;
    protected Activeness activeness;

    public Random getRandom() {
        return this.random;
    }

    @Deprecated
    public UT2004AgentInfo getUtAgentInfo() {
        return this.ut2004AgentInfo;
    }

    public EhAgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    @Deprecated
    public AgentConfig getConfig() {
        return this.config;
    }

    public Raycasting getRaycasting() {
        return this.raycasting;
    }

    public AdvancedLocomotion getMovement() {
        return this.movement;
    }

    @Deprecated
    public Game getUtGame() {
        return this.ut2004game;
    }

    public EhGame getGame() {
        return this.game;
    }

    public Communication getComm() {
        return this.comm;
    }

    public NavigationGraphBuilder getNavGraphBuilder() {
        return this.navGraphBuilder;
    }

    public IUnrealPathExecutor<ILocated> getPathExecutor() {
        return this.pathExecutor;
    }

    public IPathPlanner<ILocated> getPathPlanner() {
        return this.pathPlanner;
    }

    public IHistoricWorldView getWorldView() {
        return (IHistoricWorldView)super.getWorldView();
    }

    public FloydWarshallMap getFwMap() {
        return this.fwMap;
    }

    public EmohawkNavigation getNavigation() {
        return this.navigation;
    }

    public Activeness getActiveness() {
        return this.activeness;
    }

    public void initializeController(BOT bot) {
        super.initializeController(bot);
        this.initializeModules();
    }

    protected void initializeModules() {
        this.act = this.getAct();
        this.ut2004game = this.makeUtGame();
        this.game = this.makeGame();
        this.ut2004AgentInfo = this.makeUT2004AgentInfo();
        this.config = this.makeAgentConfig();
        this.raycasting = this.makeRaycasting();
        this.movement = this.makeAdvancedLocomotion();
        this.comm = this.makeCommunication();
        this.navGraphBuilder = this.makeNavBuilder();
        this.emoticons = this.makeEmoticons();
        this.steering = this.makeSteering();
        this.agentInfo = this.makeAgentInfo();
        this.activeness = this.makeActiveness();
        this.pathPlanner = new UT2004AStarPathPlanner(this.bot);
        this.fwMap = new FloydWarshallMap((IGhostAgent)this.bot);
        this.pathExecutor = new UT2004PathExecutor(this.bot, (AgentInfo)this.ut2004AgentInfo, this.movement, (IUT2004PathNavigator)new LoqueNavigator(this.bot, (AgentInfo)this.ut2004AgentInfo, this.movement, this.makeRunner(), (Logger)this.bot.getLog()));
        this.navigation = new EmohawkNavigation(this.bot, this.steering, this.fwMap);
        this.brain = this.makeBrain();
        this.annotationListenerRegistrator = new AnnotationListenerRegistrator((Object)this.brain, (IWorldView)this.getWorldView(), (Logger)this.bot.getLogger().getCategory("Listeners"));
        this.annotationListenerRegistrator.addListeners();
    }

    public PasswordReply getPassword() {
        return new PasswordReply(this.brain.getPassword());
    }

    public Initialize getInitializeCommand() {
        return this.brain.getInitializeCommand();
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        super.botInitialized(gameInfo, currentConfig, init);
        this.brain.botInitialized();
    }

    public void botFirstSpawn(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
        super.botFirstSpawn(gameInfo, currentConfig, init, self);
        this.brain.botFirstSpawn();
    }

    public void beforeFirstLogic() {
        super.beforeFirstLogic();
        this.brain.beforeFirstLogic();
    }

    public void logic() {
        super.logic();
        this.brain.logic();
    }

    public void botKilled(BotKilled event) {
        super.botKilled(event);
        this.brain.botKilled(event);
    }

    public void botShutdown() {
        super.botShutdown();
        this.brain.botShutdown();
    }

    protected abstract EmohawkBotBrain makeBrain();

    protected Game makeUtGame() {
        return new Game(this.bot);
    }

    protected EhGame makeGame() {
        return new EhGame(this.getWorldView());
    }

    protected UT2004AgentInfo makeUT2004AgentInfo() {
        return new UT2004AgentInfo(this.bot, this.ut2004game);
    }

    protected AgentConfig makeAgentConfig() {
        return new AgentConfig(this.bot);
    }

    protected Raycasting makeRaycasting() {
        return new Raycasting(this.bot);
    }

    protected AdvancedLocomotion makeAdvancedLocomotion() {
        return new AdvancedLocomotion(this.getBot(), (Logger)this.getBot().getLogger().getCategory("Move"));
    }

    protected Communication makeCommunication() {
        return new Communication(this.getBot(), (Logger)this.getBot().getLogger().getCategory("Communicaton"));
    }

    protected NavigationGraphBuilder makeNavBuilder() {
        return new NavigationGraphBuilder(this.bot);
    }

    protected Emoticons makeEmoticons() {
        return new Emoticons(this.bot);
    }

    protected Steering makeSteering() {
        return new Steering(this.bot);
    }

    protected IUT2004PathRunner makeRunner() {
        return new KefikRunner(this.bot, (AgentInfo)this.ut2004AgentInfo, this.movement, (Logger)this.bot.getLog());
    }

    protected EhAgentInfo makeAgentInfo() {
        return new EhAgentInfo(this.getWorldView());
    }

    protected Activeness makeActiveness() {
        return new Activeness(this.act, this.getWorldView(), this.agentInfo, this.getGame(), this.log);
    }
}

