/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.IPureHistoricWorldView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.pawn.IPawnBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.player.IPlayerBelief;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;

public class EhAgentInfo
implements ILocated {
    IPureHistoricWorldView worldView;
    IPlayerBelief self;
    double time;
    protected final IWorldEventListener<BeginMessage> beginMessageListener = new IWorldEventListener<BeginMessage>(){

        public void notify(BeginMessage event) {
            EhAgentInfo.this.time = event.getTime();
        }
    };
    protected final IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            assert (EhAgentInfo.this.time == event.getTime());
            for (IPlayerBelief player : EhAgentInfo.this.worldView.getPlausibleBeliefs().filterByClass(IPlayerBelief.class).values()) {
                if (!player.isSelf()) continue;
                EhAgentInfo.this.self = player;
                break;
            }
        }
    };

    public EhAgentInfo(IPureHistoricWorldView worldView) {
        this.worldView = worldView;
        this.time = Double.NEGATIVE_INFINITY;
        worldView.accessEvents().addEventListener(BeginMessage.class, this.beginMessageListener);
        worldView.accessEvents().addEventListener(EndMessage.class, this.endMessageListener);
    }

    public void dispose() {
        this.worldView.accessEvents().removeEventListener(BeginMessage.class, this.beginMessageListener);
        this.worldView.accessEvents().removeEventListener(EndMessage.class, this.endMessageListener);
    }

    public IPlayerBelief getPlayer() {
        return this.self;
    }

    public IPawnBelief getPawn() {
        return this.getPlayer().getPrimaryPawn().getNotHidden();
    }

    public double getTime() {
        return this.time;
    }

    public Location getLocation() {
        if (this.getPawn() == null) {
            return null;
        }
        return this.getPawn().getLocation();
    }

    public double getDistance(ILocated located) {
        if (located.getLocation() == null || this.getPawn() == null || this.getPawn().getLocation() == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.getPawn().getLocation().getDistance(located.getLocation());
    }

    public NavPoint getNearestNavPoint() {
        if (this.getLocation() == null) {
            return null;
        }
        return (NavPoint)DistanceUtils.getNearest(this.worldView.getSeenObjects().filterByClass(NavPoint.class).values(), (ILocated)this.getLocation());
    }
}

