package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;

/** Abstract implementation of IObjectReplica
 */
public abstract class AbstractObjectReplica implements IObjectReplica {
	
	/** Object replication client reference
	 *  
	 *  Set when object is replicated.
	 *  Unset when replication is finalized and object is torn-off.
	 */
	protected ObjectReplicationClient objectReplicationClient;
	
	/** Replication id
	 *  
	 *  Replicated object has the same id as the original.
	 */
	protected int replicationIndex;
		
	/** Constructor
	 */
	public AbstractObjectReplica() {
		replicationIndex = -1;
	}
		
	@Override
	public int getReplicationIndex() {
		return replicationIndex;
	}
		
	@Override
	public void initializeReplica( ObjectReplicationClient initObjectReplicationClient, int initReplicationIndex ) {
		objectReplicationClient = initObjectReplicationClient;
		replicationIndex = initReplicationIndex;
	}
	
	@Override
	public boolean isLive() {
		return objectReplicationClient != null;
	}
	
	@Override
	public void finalizeReplication()	{
		assert( objectReplicationClient != null );
		objectReplicationClient = null;
		replicationIndex = -2;
	}
}