package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object;



/** Abstract implementation of IObjectReplica
 * 
 * Stores passed type paremeters into array.
 */
public abstract class AbstractGenericObjectReplica extends AbstractObjectReplica implements IGenericObjectReplica {
	
	/** Array with type parameters
	 */
	protected SpecializedClass<?> typeParameters[];
	
	/** Constructor
	 * 
	 * @param typeParameterCount type parameter count
	 */
	public AbstractGenericObjectReplica( int typeParameterCount ) {
		typeParameters = new SpecializedClass[typeParameterCount];
	}
	

	@Override
	public void setTypeParameter(int index, SpecializedClass<?> value) {
		typeParameters[index] = value;
	}
	
	@Override
	public SpecializedClass<?> getTypeParameter(int index) {
		return typeParameters[index];
	}
	
	@Override
	public int getTypeParameterCount() {
		return typeParameters.length;
	}
}
