package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.sll;

import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PrimitiveTools;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.AbstractGenericObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.SpecializedClass;

/** Node of a singly-linked list.
*
*/
public class SinglyLinkedListNodeReplica<Element> extends AbstractGenericObjectReplica {
	
	protected Element value;
	protected SinglyLinkedListNodeReplica<Element> next;
	
	public SinglyLinkedListNodeReplica() {
		super( 1 );
	}
	
	/** Get value type parameter class
	 * 
	 * @return value type parameter class
	 */
	@SuppressWarnings("unchecked")
	public SpecializedClass<Element> getValueClass()	{
		return (SpecializedClass<Element>) typeParameters[0];
	}

	/** Get stored value
	 */ 
	public Element getValue() {
		return value;
	}
	
	/** Get next node
	 */
	public SinglyLinkedListNodeReplica<Element> getNext() {
		return next;
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public void receive( IObjectInputStream inputStream )	{
		value = (Element) PrimitiveTools.readPrimitive( getValueClass().getGenericClass(), inputStream );
		next = (SinglyLinkedListNodeReplica<Element>) inputStream.readObjectRef();
		assert( next == null || next.getValueClass().equals( getValueClass() ) );
	}
}
