package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map.Entry;

import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.sll.SinglyLinkedListReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.AbstractGenericObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.SpecializedClass;

/** A map backed-up by a list
*
* Keys are strings.
*/
public class ListMapReplica<KeyType,ValueType> extends AbstractGenericObjectReplica implements Iterable<Entry<KeyType,ValueType>> {
	
	protected SinglyLinkedListReplica<ListMapEntryReplica<KeyType,ValueType>> list;
		
	public ListMapReplica() {
		super(2);
	}
	
	/** Get key type parameter class
	 * 
	 * @return key type parameter class
	 */
	public SpecializedClass<KeyType> getKeyClass() {
		@SuppressWarnings("unchecked")
		SpecializedClass<KeyType> retval = (SpecializedClass<KeyType>) typeParameters[0];
		return retval;
	}
	
	/** Get value type parameter class
	 * 
	 * @return value type parameter class
	 */
	public SpecializedClass<ValueType> getValueClass() {
		@SuppressWarnings("unchecked")
		SpecializedClass<ValueType> retval = (SpecializedClass<ValueType>) typeParameters[1];
		return retval;
	}
	
	@Override
	public Iterator<Entry<KeyType,ValueType>> iterator()
	{
		final Iterator<ListMapEntryReplica<KeyType, ValueType>> iterator = list.iterator();
		return new Iterator<Entry<KeyType,ValueType>>() {
			
			@Override
			public boolean hasNext() {
				return iterator.hasNext();
			}
			
			@Override
			public Entry<KeyType,ValueType> next() {
				return iterator.next();
			}
			
			@Override
			public void remove() {
				throw new UnsupportedOperationException( "Read-only replica." );
			}
		};
	}
	
	
	/** Get entry count
	 * 
	 * @return entry count
	 */
	public int size() {
		return list.size();
	}

	/** Tell if map is empty
	 * 
	 * @return true if map is empty
	 */
	public boolean isEmpty() {
		return size() == 0;
	}

	/** Tell if mapping exists for a key
	 *
	 * @param key key
	 * @return true if mapping exists for the key
	 */
	public boolean containsKey(KeyType key) {
		return findEntry( key ) != null;
	}

	public boolean containsValue(ValueType value) {
		for ( ListMapEntryReplica<KeyType,ValueType> entry : list ) {
			if ( entry.getValue().equals( value ) ) {
				return true;
			}
		}
		return false;
	}
	
	/** Get value of mapped to key
	 *
	 * @param key key, mapping must be defined for the key
	 * @return value mapped to key
	 */
	public ValueType get( KeyType key ) {
		ListMapEntryReplica<KeyType,ValueType> entry = findEntry( key );
		
		if ( entry == null ) {
			return null;
		}
			
		return entry.getValue();
	}
	
	/** see EhIReplicableObject
	 */
	@Override
	public void receive( IObjectInputStream inputStream) {
		@SuppressWarnings("unchecked")
		SinglyLinkedListReplica<ListMapEntryReplica<KeyType,ValueType>> receivedList = (SinglyLinkedListReplica<ListMapEntryReplica<KeyType,ValueType>>) inputStream.readObjectRef();
		list = receivedList;
		assert( list.getValueClass().equals( getEntryClass() ) );
	}
	
	protected ListMapEntryReplica<KeyType,ValueType> findEntry( KeyType key )
	{
		for ( ListMapEntryReplica<KeyType,ValueType> entry : list ) {
			if ( entry.getKey().equals( key ) )	{
				return entry;
			}
		}
		return null;
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	protected SpecializedClass<ListMapEntryReplica<KeyType,ValueType>> getEntryClass() {
		return new SpecializedClass<ListMapEntryReplica<KeyType,ValueType>>(
			(Class) ListMapEntryReplica.class,
			Arrays.asList( new SpecializedClass<?>[] { getKeyClass(), getValueClass() } )
		);
	}
}