package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds;

import java.util.Map.Entry;

import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PrimitiveTools;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.AbstractGenericObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.SpecializedClass;

/** Mapping entry of a list map
*/
public class ListMapEntryReplica<KeyType,ValueType> extends AbstractGenericObjectReplica implements Entry<KeyType,ValueType> {

	protected KeyType key;
	protected ValueType value;
	
	public ListMapEntryReplica() {
		super(2);
	}
	
	public ListMapEntryReplica( KeyType key, ValueType value ) {
		super(2);
		this.key = key;
		this.value = value;
	}
	
	/** Get key type parameter class
	 * 
	 * @return key type parameter class
	 */
	public SpecializedClass<KeyType> getKeyClass() {
		@SuppressWarnings("unchecked")
		SpecializedClass<KeyType> retval = (SpecializedClass<KeyType>) typeParameters[0];
		return retval;
	}
	
	/** Get value type parameter class
	 * 
	 * @return value type parameter class
	 */
	public SpecializedClass<ValueType> getValueClass() {
		@SuppressWarnings("unchecked")
		SpecializedClass<ValueType> retval = (SpecializedClass<ValueType>) typeParameters[1];
		return retval;
	}
	
	@Override
	public ValueType getValue() {
		return value;
	}
	
	@Override
	public KeyType getKey() {
		return key;
	}
	
	@Override
	public void receive( IObjectInputStream stream )
	{
		key = PrimitiveTools.readPrimitive( getKeyClass().getGenericClass(), stream );
		value = PrimitiveTools.readPrimitive( getValueClass().getGenericClass(), stream );
	}

	@Override
	public ValueType setValue(ValueType value) {
		throw new UnsupportedOperationException( "Read-only replica." );
	}
}