package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.primitiveList;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map.Entry;

/** List attribute view
 *  
 * Filters attribute not matching given list type.
 */
public interface IListAttributeView<Element> {

	/** Get read-only value list of an existing attribute
	 * 
	 * Not available for write attributes on client-side.
	 *
	 * @param attributeName attribute name, must exist and have the right type
	 * @return attribute value list
	 */
	Collection<Element> read( String attributeName );
	
	/** Tell if attribute exists and has the right type
	 * 
	 * @param attributeName attribute name
	 * @return true if attribute exists and has the right type and access
	 */
	boolean exists( String attributeName );
	
	/** Iterate over attributes in view
	 * 
	 * @return view iterator
	 */
	Iterator<Entry<String,ListAttributeReplica<Element>>> iterator();
}