package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.primitive;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.AttributeRawView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.IAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.PrimitiveBoxReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.SpecializedClass;

/** Primitive attribute view
 * 
 * Filters attribute not matching given list type.
 */
public class PrimitiveAttributeView<T> implements IPrimitiveAttributeView<T> {

	protected AttributeRawView<PrimitiveAttributeReplica<T>> rawView;
	protected Class<T> primitiveClass;
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public PrimitiveAttributeView( 
		Class<T> primitiveClass,
		Map<String,IAttributeReplica> attributes
	) {
		this.primitiveClass = primitiveClass;
		rawView = new AttributeRawView<PrimitiveAttributeReplica<T>>( 
			attributes,
			new SpecializedClass<PrimitiveAttributeReplica<T>>(
				(Class) PrimitiveAttributeReplica.class,
				Arrays.asList( new SpecializedClass<?>[] { SpecializedClass.fromPlain( primitiveClass ) } ) 
			)
		);
	}
	
	@Override
	public T get( String attributeName ) {
		PrimitiveAttributeReplica<T> attribute = rawView.getAttributeRecord( attributeName );
		PrimitiveBoxReplica<T> pbox = attribute.getValue();
		assert( pbox.getValueClass().equals( SpecializedClass.fromPlain( primitiveClass ) ) );
		return pbox.get();	
	}
	
	@Override
	public boolean exists( String attributeName ) {
		return rawView.exists( attributeName );
	}
	
	@Override
	public Iterator<Entry<String,PrimitiveAttributeReplica<T>>> iterator() {
		return rawView.iterator();
	}
}