package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.foggyRefList;

import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.AttributeRawView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.IAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.FoggyReferenceReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.sll.SinglyLinkedListReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.SpecializedClass;

/** Foggy reference list attribute view
 *  
 * Filters attribute not matching given list type.
 */
public class FoggyRefListAttributeView implements IFoggyRefListAttributeView {
	
	protected AttributeRawView<FoggyRefListAttributeReplica> rawView;
		
	public FoggyRefListAttributeView( 
		Map<String,IAttributeReplica> attributes
	) {
		rawView = new AttributeRawView<FoggyRefListAttributeReplica>( 
			attributes,
			SpecializedClass.fromPlain( FoggyRefListAttributeReplica.class )
		);
	}
	
	@Override
	public SinglyLinkedListReplica<FoggyReferenceReplica<IObjectReplica>> read( String attributeName ) {
		FoggyRefListAttributeReplica attribute = rawView.getAttributeRecord( attributeName );
		return attribute.getValue();
	}

	@Override
	public boolean exists( String attributeName ) {
		return rawView.exists( attributeName );
	}
	
	@Override
	public Iterator<Entry<String,FoggyRefListAttributeReplica>> iterator() {
		return rawView.iterator();
	}
}
