package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.foggyRef;

import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.ds.IFoggyReference;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.AttributeRawView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.IAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.SpecializedClass;

/** Primitive attribute view
 * 
 * Filters attribute not matching given list type.
 */
public class FoggyRefAttributeView implements IFoggyRefAttributeView {

	protected AttributeRawView<FoggyRefAttributeReplica> rawView;
	
	public FoggyRefAttributeView( Map<String,IAttributeReplica> attributes ) {
		rawView = new AttributeRawView<FoggyRefAttributeReplica>( 
			attributes,
			SpecializedClass.fromPlain( FoggyRefAttributeReplica.class )
		);
	}
	
	@Override
	public IFoggyReference<IObjectReplica> get(String attributeName) {
		FoggyRefAttributeReplica attribute = rawView.getAttributeRecord( attributeName );
		return attribute.getValue();
	}
	
	@Override
	public boolean exists( String attributeName ) {
		return rawView.exists( attributeName );
	}
	
	@Override
	public Iterator<Entry<String,FoggyRefAttributeReplica>> iterator() {
		return rawView.iterator();
	}
}