package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.foggyRef.FoggyRefAttributeView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.foggyRef.IFoggyRefAttributeView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.foggyRefList.FoggyRefListAttributeView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.foggyRefList.IFoggyRefListAttributeView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.primitive.PrimitiveAttributeView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.primitiveList.ListAttributeView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.AbstractObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.SpecializedClass;

/** Attribute manager
 *  
 * Manages attributes of various types.
 * Attribute name must be unique among all attribute types.
 */
public class AttributeManagerReplica extends AbstractObjectReplica implements IAttributeManagerReplica {
	
	protected HashMap<String,IAttributeReplica> attributes;
	
	public AttributeManagerReplica() {
		attributes = new HashMap<String,IAttributeReplica>();
	}
	
	@Override
	public PrimitiveAttributeView<Integer> ints() {
		return new PrimitiveAttributeView<Integer>( Integer.class, attributes );
	}
	
	@Override
	public PrimitiveAttributeView<Float> floats() {
		return new PrimitiveAttributeView<Float>( Float.class, attributes );
	}
	
	@Override
	public PrimitiveAttributeView<Boolean> bools() {
		return new PrimitiveAttributeView<Boolean>( Boolean.class, attributes );
	}
	
	@Override
	public PrimitiveAttributeView<String> strings() {
		return new PrimitiveAttributeView<String>( String.class, attributes );
	}
	
	@Override
	public IFoggyRefAttributeView refs() {
		return new FoggyRefAttributeView( attributes );
	}
	
	@Override
	public ListAttributeView<Integer> intLists() {
		return new ListAttributeView<Integer>( SpecializedClass.fromPlain( Integer.class ), attributes );
	}
	
	@Override
	public ListAttributeView<Float> floatLists() {
		return new ListAttributeView<Float>( SpecializedClass.fromPlain( Float.class ), attributes );
	}
	
	@Override
	public ListAttributeView<Boolean> boolLists() {
		return new ListAttributeView<Boolean>( SpecializedClass.fromPlain( Boolean.class ), attributes );
	}
	
	@Override
	public ListAttributeView<String> stringLists() {
		return new ListAttributeView<String>( SpecializedClass.fromPlain( String.class ), attributes );
	}
	
	@Override
	public IFoggyRefListAttributeView refLists() {
		return new FoggyRefListAttributeView( attributes );
	}
	
	@Override
	public Iterator<Entry<String,IAttributeReplica>> iterator() {
		return attributes.entrySet().iterator();
	}
	
	@Override
	public void receive( IObjectInputStream inputStream )	{
		int entryCount = inputStream.readInt();
		for ( int i=0; i<entryCount; ++i ) {
			String key = inputStream.readString();
			IAttributeReplica value = (IAttributeReplica) inputStream.readObjectRef();
			attributes.put( key, value );
		}
	}
}