package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication;

import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.IReplicationEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.ISimulationClock;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.event.IReplicaEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;
import cz.cuni.amis.utils.listener.IListener;


public interface IObjectReplicationClient {

	/** Initialize simulation clock
	 * 
	 * @param simulationClock simulation clock
	 */
	void initSimulationClock(ISimulationClock simulationClock);
	
	/** Get object by replication ID
	 * 
	 * It is an error to request undefined object.
	 * 
	 * @param replicationId replication ID
	 * @return object with required ID
	 */
	IObjectReplica getObject( int replicationId );
	
	/** Tell if there is an replicated object with given ID
	 * 
	 * @param replicationId replication ID
	 * @return true if there is an replicated object with given ID
	 */
	boolean exists( int replicationId );
	
	/** Apply replication event
	 * 
	 * @param event replication event
	 */
	void applyReplicationEvent( IReplicationEvent event );
	
	/** Register object added/changed/removed listener
	 * 
	 * @param listener listener
	 */
	void registerReplicaEventListener( IListener<IReplicaEvent> listener );
	
	/** Forget object added/changed/removed listener
	 * 
	 * @param listener listener
	 */
	void forgetReplicaEventListener( IListener<IReplicaEvent> listener );
}
