package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.worldObject;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.worldObject.ISituated;

/** Memorization of a world object situation
 * 
 * Equivalent of UDK EhActorSituation.
 * 
 * @author Paletz
 */
public class SituationMemorizationSubrecord implements ISituated {

	protected Location location;
	protected Rotation rotation;
	protected Velocity velocity;
	
	public SituationMemorizationSubrecord( Location location, Rotation rotation, Velocity velocity ) {
		this.location = location;
		this.rotation = rotation;
		this.velocity = velocity;
	}
	
	public SituationMemorizationSubrecord( ISituated situated ) {
		this( situated.getLocation(), situated.getRotation(), situated.getVelocity() );
	}
	
	@Override
	public Location getLocation() {
		return location;
	}

	@Override
	public Rotation getRotation() {
		return rotation;
	}

	@Override
	public Velocity getVelocity() {
		return velocity;
	}
}
