package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.worldObject;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.ISnapshotMemorizer;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.worldObject.IEntityMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.worldObject.AbstractEntityReplica;

/** Physical entity replica
*
* Equivalent of UDK EhAbstractEntityEssence.
* 
* @author Paletz
*/
public class AbstractEntityMemorization extends AbstractViewableObjectMemorization implements IEntityMemorization {
	
	protected SituationMemorizationSubrecord situation;
	
	public AbstractEntityMemorization( 
		final AbstractEntityReplica replica,
		final ISnapshotMemorizer snapshotMemorizer, 
		IDeferredConstructorChainer deferredConstructorChainer 
	) {
		super(replica, snapshotMemorizer, deferredConstructorChainer);
		
		situation = new SituationMemorizationSubrecord( replica );
	}
	
	@Override
	public Location getLocation() {
		return situation.getLocation();
	}

	@Override
	public Velocity getVelocity() {
		return situation.getVelocity();
	}

	@Override
	public Rotation getRotation() {
		return situation.getRotation();
	}
}
