package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.player;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.ds.IFoggyReference;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.ISnapshotMemorizer;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.pawn.IPawnMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.player.IPlayerMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.ds.FoggyReferenceMemorizationSubrecord;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.pawn.PawnMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.worldObject.AbstractViewableObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.pawn.IPawnReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.player.PlayerReplica;

/** Player soul memorization
 * 
 * Equivalent of UDK EhController.
 * 
 * @author Paletz
 */
public class PlayerMemorization extends AbstractViewableObjectMemorization implements IPlayerMemorization {

	protected boolean isSelf;
	protected FoggyReferenceMemorizationSubrecord<PawnMemorization> primaryPawn;
	
	public PlayerMemorization(
		final PlayerReplica replica,
		final ISnapshotMemorizer snapshotMemorizer,
		IDeferredConstructorChainer deferredConstructorChainer 
	) {
		super( replica, snapshotMemorizer, deferredConstructorChainer );
		isSelf = replica.isSelf();
		deferredConstructorChainer.addDeferredConstructor(
			new IDeferredConstructor() {
				@Override
				public void construct() {
					primaryPawn = FoggyReferenceMemorizationSubrecord.<PawnMemorization,IPawnReplica>makeFromReplica(
						snapshotMemorizer, 
						replica.getPrimaryPawn(),
						PawnMemorization.class
 					);
				}
			}
		);
	}
	
	@Override
	public IFoggyReference<? extends IPawnMemorization> getPrimaryPawn() {
		return primaryPawn;
	}
	
	@Override
	public boolean isSelf() {
		return isSelf;
	}
}
