package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.SimulationTime;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.action.ActionRegistryMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.game.GameMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.pawn.PawnMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.player.PlayerMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.action.ActionRegistryReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.game.GameReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.pawn.PawnReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.player.PlayerReplica;
import cz.cuni.amis.utils.ExceptionToString;

/** Emohawk implementation of snapshot memorizer
 * 
 * @author Paletz
 */
public class SnapshotMemorizer implements ISnapshotMemorizer {
	
	protected Map<IObjectReplica,IObjectMemorization> memorizationCache;
	protected Map<IObjectMemorization,IObjectReplica> reverseMemorizationCache;
	protected SimulationTime currentSnapshotTime;
	
	protected Map<Class<? extends IObjectReplica>,Class<? extends IObjectMemorization>> classMap;
	
	public SnapshotMemorizer() {
		super();
		memorizationCache = new HashMap<IObjectReplica,IObjectMemorization>();
		reverseMemorizationCache = new HashMap<IObjectMemorization,IObjectReplica>();
		currentSnapshotTime = null;
		classMap = new HashMap<Class<? extends IObjectReplica>,Class<? extends IObjectMemorization>>();
		
		classMap.put( ActionRegistryReplica.class, ActionRegistryMemorization.class );
		
		classMap.put( GameReplica.class, GameMemorization.class );
		
		classMap.put( PawnReplica.class, PawnMemorization.class );
		
		classMap.put( PlayerReplica.class, PlayerMemorization.class );
	}
	
	@Override
	public IObjectMemorization getMemorization( Object object ) {
		if ( object == null ) {
			return null;
		}
		
		if ( !(object instanceof IObjectReplica) ) {
			throw new AssertionError( "Memorizer implementation can handle only replicas (IObjectReplica)." );
		}
		
		IObjectReplica replica = (IObjectReplica) object;
		
		assert( replica.isLive() );
		
		IObjectMemorization memorization = memorizationCache.get( replica );
		if ( memorization == null ) {
			SemifinishedMemorization semifinishedMemorization = makeMemorization(replica);
			memorization = semifinishedMemorization.memorization;
			memorizationCache.put( replica, memorization );
			reverseMemorizationCache.put( memorization, replica);
			semifinishedMemorization.finishConstruction();
		}
		IObjectMemorization retval = memorization;
		return retval;
	}
	
	@Override
	public IObjectReplica getPreimage( IObjectMemorization freshMemorization ) {
		return reverseMemorizationCache.get( freshMemorization );
	}
	
	@Override
	public void nextSnapshot( SimulationTime nextSnapshotTime ) {
		memorizationCache.clear(); // without cache reset most memorizations wouldn't be updated 
		reverseMemorizationCache.clear();
		assert( currentSnapshotTime == null || currentSnapshotTime.getMilliSeconds() < nextSnapshotTime.getMilliSeconds() );
		currentSnapshotTime = nextSnapshotTime;	
	}		
	
	@Override
	public SimulationTime getSnapshotTime() {
		return currentSnapshotTime;
	}
	
	/** Make a new memorization of an observed object
	 * 
	 * @param object observed object
	 * @return memorization of the object
	 */
	protected SemifinishedMemorization makeMemorization( IObjectReplica object ) {
		SemifinishedMemorization retval = new SemifinishedMemorization();
		
		Class<? extends IObjectReplica> replicaClass = object.getClass();
		Class<? extends IObjectMemorization> memorizationClass = classMap.get( replicaClass );
		assert( memorizationClass != null );
		
		try {
			retval.memorization = (
				memorizationClass
				.getConstructor( replicaClass, ISnapshotMemorizer.class, IDeferredConstructorChainer.class )
				.newInstance( object, this, retval )
			);
			return retval;
		} catch (InstantiationException e) {
			throw new AssertionError( "Failed to create memorization." + ExceptionToString.process(e) );
		} catch (IllegalAccessException e) {
			throw new AssertionError( "Failed to create memorization." + ExceptionToString.process(e) );
		} catch (IllegalArgumentException e) {
			throw new AssertionError( "Failed to create memorization." + ExceptionToString.process(e) );
		} catch (InvocationTargetException e) {
			throw new AssertionError( "Failed to create memorization." + ExceptionToString.process(e) );
		} catch (NoSuchMethodException e) {
			throw new AssertionError( "Failed to create memorization." + ExceptionToString.process(e) );
		} catch (SecurityException e) {
			throw new AssertionError( "Failed to create memorization." + ExceptionToString.process(e) );
		}
		
	}
}
