package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.SimulationTime;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.object.IObjectMemorization;

/** Snapshot memorizer
 * 
 * Creates a memorization current state of a replica.
 * Does a deep copy with caching and thus can effectively memorize whole world as a snapshot.
 * 
 * @author Paletz
 */
public interface ISnapshotMemorizer {

	/** Get memorization of an observed object
	 * 
	 * Uses cache to handle circular references.
	 * 
	 * @param object observed object
	 * @return memorization of the object
	 */
	IObjectMemorization getMemorization(Object object);
	
	/** Get preimage of fresh memorization
	 * 
	 * Reverse of getMemorization().
	 * 
	 * @param freshMemorization memorization, must be fresh ( memorization epoch time == epoch time )
	 * @return preimage of the memorization
	 */
	Object getPreimage( IObjectMemorization freshMemorization );
		
	/** Advance to next snapshot
	 * 
	 * @param nextSnapshotTime
	 */
	void nextSnapshot( SimulationTime nextSnapshotTime );

	/** Get current snapshot time
	 * 
	 * @return snapshot time
	 */
	SimulationTime getSnapshotTime();
}
