package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.worldObject;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.SightingMemory.BeliefSupport;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.object.AbstractObjectBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.worldObject.IViewableObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.worldObject.AbstractViewableObjectMemorization;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;

/** Viewable world object belief
 * 
 * @author Paletz
 */
public abstract class AbstractViewableObjectBelief extends AbstractObjectBelief {

	public AbstractViewableObjectBelief( AbstractViewableObjectMemorization memorization, BeliefSupport beliefSupport ) {
		super( memorization, beliefSupport );
	}
	
	@Override
	public void updateMemorization( IObjectMemorization newMemorization ) {
		assert( newMemorization instanceof AbstractViewableObjectMemorization );
		super.updateMemorization( newMemorization );
	}
		
	@Override
	public IViewableObjectBelief getImmutableFacade() {
		return (IViewableObjectBelief) immutableFacade;
	}

	@Override
	protected AbstractViewableObjectBeliefImmutableFacade makeImmutableFacade() {
		return new AbstractViewableObjectBeliefImmutableFacade();
	}
	
	protected AbstractViewableObjectMemorization getMemorizationImpl() {
		return (AbstractViewableObjectMemorization) memorization;
	}
	
	public class AbstractViewableObjectBeliefImmutableFacade extends AbstractObjectBeliefImmutableFacade implements IViewableObjectBelief {
		
		@Override
		public IViewableObjectMemorization getMemorization() {
			return getMemorizationImpl();
		}
		
		@Override
		public long getSimTime() {
			return getMemorization().getSimTime(); 
		}
		
		@Override
		public WorldObjectId getId() {
			return getMemorization().getId();
		}
		
		@Override
		public boolean isVisible() {
			return beliefSupport.getSnapshotTime().getMilliSeconds() == getMemorizationImpl().getSimTime();
		}
		
		@Override
		public ILocalWorldObject getLocal() {
			return getMemorization().getLocal();
		}

		@Override
		public ISharedWorldObject getShared() {
			return getMemorization().getShared();
		}

		@Override
		public IStaticWorldObject getStatic() {
			return getMemorization().getStatic();
		}
	}
}
