package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.worldObject;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.SightingMemory.BeliefSupport;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IEntityBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.worldObject.IEntityMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.worldObject.AbstractEntityMemorization;


/** Physical entity replica
*
* Equivalent of UDK EhAbstractEntityEssence.
* 
* @author Paletz
*/
public abstract class AbstractEntityBelief extends AbstractViewableObjectBelief {
	
	public AbstractEntityBelief( AbstractEntityMemorization memorization, BeliefSupport beliefSupport ) {
		super( memorization, beliefSupport );
	}
	
	@Override
	public void updateMemorization( IObjectMemorization newMemorization ) {
		assert( newMemorization instanceof AbstractEntityMemorization );
		super.updateMemorization( newMemorization );
	}
		
	@Override
	public IViewableObjectBelief getImmutableFacade() {
		return (IViewableObjectBelief) immutableFacade;
	}

	@Override
	protected AbstractEntityBeliefImmutableFacade makeImmutableFacade() {
		return new AbstractEntityBeliefImmutableFacade();
	}
	
	protected AbstractEntityMemorization getMemorizationImpl() {
		return (AbstractEntityMemorization) memorization;
	}
	
	public class AbstractEntityBeliefImmutableFacade extends AbstractViewableObjectBeliefImmutableFacade implements IEntityBelief {
		@Override
		public IEntityMemorization getMemorization() {
			return getMemorizationImpl();
		}

		@Override
		public Location getLocation() {
			return getMemorization().getLocation();
		}

		@Override
		public Velocity getVelocity() {
			return getMemorization().getVelocity();
		}

		@Override
		public Rotation getRotation() {
			return getMemorization().getRotation();
		}
	}
}