package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.object;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.SightingMemory.BeliefSupport;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.object.IObjectBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.object.AbstractObjectMemorization;

/** Object belief
 * 
 * @author Paletz
 */
public abstract class AbstractObjectBelief {

	protected BeliefSupport beliefSupport;
	protected AbstractObjectMemorization memorization;
	protected boolean isPlausible;
	protected IObjectBelief immutableFacade;
	
	public AbstractObjectBelief( AbstractObjectMemorization memorization, BeliefSupport beliefSupport ) {
		this.memorization = memorization;
		this.beliefSupport = beliefSupport;
		isPlausible = true;
		immutableFacade = makeImmutableFacade();
	}

	/** Update memorization
	 * 
	 * @param newMemorization fresher memorization
	 */
	public void updateMemorization( IObjectMemorization newMemorization ) {
		memorization = (AbstractObjectMemorization) newMemorization; 
		isPlausible = true;
	}
	
	/** Contradict
	 */
	public void contradict() {
		isPlausible = false;
	}
	
	/** Get immutable facade
	 * 
	 * The returned facade hides internal service methods.
	 * 
	 * @return immutable facade
	 */
	public IObjectBelief getImmutableFacade() {
		return immutableFacade;
	}

	protected AbstractObjectBeliefImmutableFacade makeImmutableFacade() {
		return new AbstractObjectBeliefImmutableFacade();
	}
		
	public class AbstractObjectBeliefImmutableFacade implements IObjectBelief {
		
		@Override
		public IObjectMemorization getMemorization() {
			return memorization;
		}

		@Override
		public boolean isPlausible() {
			return isPlausible;
		}
	}
}
