package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.action;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.SightingMemory.BeliefSupport;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.action.IActionBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.worldObject.AbstractViewableObjectBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.action.IActionMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.action.AbstractActionMemorization;

/** Abstract action belief
 * 
 * @author Paletz
 */
public abstract class AbstractActionBelief extends AbstractViewableObjectBelief {

	/** Constructor
	 */
	public AbstractActionBelief( AbstractActionMemorization memorization, BeliefSupport beliefSupport ) {
		super(memorization, beliefSupport);
	}
	
	@Override
	public void updateMemorization( IObjectMemorization newMemorization ) {
		assert( newMemorization instanceof AbstractActionMemorization );
		super.updateMemorization( newMemorization );
	}
	
	@Override
	public IActionBelief getImmutableFacade() {
		return (IActionBelief) immutableFacade;
	}

	@Override
	protected AbstractActionBeliefImmutableFacade makeImmutableFacade() {
		return new AbstractActionBeliefImmutableFacade();
	}
	
	protected AbstractActionMemorization getMemorizationImpl() {
		return (AbstractActionMemorization) memorization;
	}
	
	public class AbstractActionBeliefImmutableFacade extends AbstractViewableObjectBeliefImmutableFacade implements IActionBelief {
		
		@Override
		public IActionMemorization getMemorization() {
			return getMemorizationImpl();
		}
		
		@Override
		public String getActionName() {
			return getMemorization().getActionName();
		}
	}
}

