package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.ISimulationClock;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.SimulationTime;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IViewableObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IWorldObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.IWorldObjectUpdater;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.ISightingMemory;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.ISnapshotMemorizer;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;

/** Historic object updater implementation
 * 
 * @see IHistoricWorldObjectUpdater
 * 
 * @author Paletz
 */
public class HistoricWorldObjectUpdater implements IHistoricWorldObjectUpdater {

	/** World object updater that maintains replica-type world objects
	 */
	protected IWorldObjectUpdater replicationWorldObjectUpdater;
	
	/** Viewable world object registry that maintains visible world object listing of replica-type world objects
	 */
	protected IViewableObjectRegistry replicationWorldObjectRegistry;
	
	/** Sighting memory managing object beliefs (creating, updating, contradicting and forgetting) 
	 */
	protected ISightingMemory sightingMemory;
	
	/** Snapshot memorizer creating memorizations of non-historic objects
	 */
	protected ISnapshotMemorizer snapshotMemorizer;
	
		
	@Inject
	public HistoricWorldObjectUpdater(
		IWorldObjectUpdater replicationWorldObjectUpdater,
		IViewableObjectRegistry replicationWorldObjectRegistry,
		ISightingMemory sightingMemory,
		ISnapshotMemorizer snapshotMemorizer
	) {
		this.replicationWorldObjectUpdater = replicationWorldObjectUpdater;
		this.replicationWorldObjectRegistry = replicationWorldObjectRegistry;
		this.sightingMemory = sightingMemory;
		this.snapshotMemorizer = snapshotMemorizer;
		
		replicationWorldObjectUpdater.initWorldObjectRegistry( replicationWorldObjectRegistry );
		sightingMemory.initInputViewableWorldObjectRegistry( replicationWorldObjectRegistry );
		sightingMemory.initMemorizer( snapshotMemorizer );
	}
	
	@Override
	public double getShortTermMemoryDuration() {
		return sightingMemory.getShortTermMemoryDuration();
	}

	@Override
	public void setShortTermMemoryDuration(double durationSeconds) {
		sightingMemory.setShortTermMemoryDuration( durationSeconds );
	}	

	@Override
	public void applyWorldObjectUpdate(IWorldChangeEvent event) {
		if ( event instanceof BeginMessage ) {
			snapshotMemorizer.nextSnapshot( SimulationTime.fromMilliSeconds( event.getSimTime() ) );
		}
		
		replicationWorldObjectUpdater.applyWorldObjectUpdate(event);
		
		if ( event instanceof EndMessage ) {
			sightingMemory.refresh();
		}
	}

	@Override
	public void initWorldObjectRegistry( IWorldObjectRegistry worldObjectRegistry ) {
		sightingMemory.initOutputWorldObjectRegistry( worldObjectRegistry );
	}
	
	@Override
	public void initSimulationClock( ISimulationClock simulationClock ) {
		sightingMemory.initSimulationClock( simulationClock );
		replicationWorldObjectUpdater.initSimulationClock( simulationClock );
	}
	
	@Override
	public void contradict( IViewableObjectBelief belief ) {
		sightingMemory.contradict( belief );
	}
}
